  { INPUT.INC }

  PROCEDURE UpCaseString;
  VAR
    i : Integer;
  BEGIN
    FOR i := 1 TO Length(CommandString) DO
      CommandString[i] := UpCase(CommandString[i]);
  END;                        {UpCaseString}

  PROCEDURE ClearString;
  VAR
    i : Integer;
  BEGIN
    FOR i := 1 TO Length(ParseString) DO
      ParseString[i] := ' ';
    ParseString[0] := Char(0);
  END;                        {ClearString}

  PROCEDURE ClearArg(ArgNumber : Integer);
  VAR
    i : Integer;
  BEGIN
    CASE ArgNumber OF
      1 : BEGIN
            FOR i := 1 TO Length(Argument) DO
              Argument[i] := ' ';
            Argument[0] := Char(0);
          END;
      2 : BEGIN
            FOR i := 1 TO Length(Argument1) DO
              Argument1[i] := ' ';
            Argument1[0] := Char(0);
            FOR i := 1 TO Length(Argument2) DO
              Argument2[i] := ' ';
            Argument2[0] := Char(0);
          END;
      4 : BEGIN
            FOR i := 1 TO Length(Argument1) DO
              Argument1[i] := ' ';
            Argument1[0] := Char(0);
            FOR i := 1 TO Length(Argument2) DO
              Argument2[i] := ' ';
            Argument2[0] := Char(0);
            FOR i := 1 TO Length(Argument3) DO
              Argument3[i] := ' ';
            Argument3[0] := Char(0);
            FOR i := 1 TO Length(Argument4) DO
              Argument4[i] := ' ';
            Argument4[0] := Char(0);
          END;
    END;                      {Case}
  END;                        {ClearArg}

  PROCEDURE RemoveSpace;
  VAR
    i, k : Integer;
    SpaceCount : Integer;
  BEGIN
    k := 1;
    SpaceCount := 0;
    FOR I := 1 TO Length(CommandString) DO
      IF CommandString[i] <> ' ' THEN { no space }
        BEGIN
          IF CommandString[i] <> #9 THEN { no tab }
            BEGIN
              ParseString[k] := CommandString[i];
              k := k+1;
            END
          ELSE
            SpaceCount := SpaceCount+1;
        END
      ELSE
        SpaceCount := SpaceCount+1;
    ParseString[0] := Char(Integer(Length(CommandString))-SpaceCount);
  END;                        {RemoveSpace}

  PROCEDURE GetArgument;
  VAR
    i, k, DigitCount : Integer;
  BEGIN
    k := 1;
    DigitCount := 0;
    hex := False;
    FOR i := 1 TO Length(ParseString) DO
      BEGIN
        IF ParseString[i] IN ['0'..'9'] THEN
          BEGIN
            WHILE ParseString[i] IN ['0'..'9', 'A'..'F'] DO
              BEGIN
                Argument[k] := ParseString[i];
                k := k+1;
                DigitCount := DigitCount+1;
                i := i+1;
              END;
            IF ParseString[i] = 'H' THEN
              hex := True
          END;                {if}
      END;                    {for}
    Argument[0] := Char(DigitCount);
    ClearString;
  END;                        {GetArgument}


  PROCEDURE GetTwoArguments;
  VAR
    i, k, DigitCount : Integer;
    digits : Boolean;
  BEGIN
    k := 1;
    i := 1;
    DigitCount := 0;
    digits := False;
    WHILE digits = False DO
      BEGIN
        IF ParseString[i] IN ['0'..'9'] THEN
          BEGIN
            digits := True;
            WHILE ParseString[i] IN ['0'..'9'] DO
              BEGIN
                Argument1[k] := ParseString[i];
                k := k+1;
                DigitCount := DigitCount+1;
                i := i+1;
              END;
            Argument1[0] := Char(DigitCount);
            IF ParseString[i] = ',' THEN
              BEGIN
                i := i+1;
                k := 1;
                DigitCount := 0;
              END
            ELSE
              BEGIN
                CoordError := True;
                Exit;
              END;
            WHILE ParseString[i] IN ['0'..'9'] DO
              BEGIN
                Argument2[k] := ParseString[i];
                k := k+1;
                DigitCount := DigitCount+1;
                i := i+1;
              END;
            Argument2[0] := Char(DigitCount)
          END;                {if}
        i := i+1;
      END;                    {while}
    ClearString;
    CoordError := False;
  END;                        {GetTwoArguments}

  PROCEDURE GetFourArguments;
  VAR
    i, k, DigitCount : Integer;
    digits : Boolean;
  BEGIN
    k := 1;
    i := 1;
    DigitCount := 0;
    digits := False;
    WHILE digits = False DO
      BEGIN
        IF ParseString[i] IN ['0'..'9'] THEN
          BEGIN
            digits := True;
            WHILE ParseString[i] IN ['0'..'9'] DO
              BEGIN
                Argument1[k] := ParseString[i];
                k := k+1;
                DigitCount := DigitCount+1;
                i := i+1;
              END;
            Argument1[0] := Char(DigitCount);
            IF ParseString[i] = ',' THEN
              BEGIN
                i := i+1;
                k := 1;
                DigitCount := 0;
              END
            ELSE
              BEGIN
                CoordError := True;
                Exit;
              END;
            WHILE ParseString[i] IN ['0'..'9'] DO
              BEGIN
                Argument2[k] := ParseString[i];
                k := k+1;
                DigitCount := DigitCount+1;
                i := i+1;
              END;
            Argument2[0] := Char(DigitCount);
            IF ParseString[i] = ',' THEN
              BEGIN
                i := i+1;
                k := 1;
                DigitCount := 0;
              END
            ELSE
              BEGIN
                CoordError := True;
                Exit;
              END;
            WHILE ParseString[i] IN ['0'..'9'] DO
              BEGIN
                Argument3[k] := ParseString[i];
                k := k+1;
                DigitCount := DigitCount+1;
                i := i+1;
              END;
            Argument3[0] := Char(DigitCount);
            IF ParseString[i] = ',' THEN
              BEGIN
                i := i+1;
                k := 1;
                DigitCount := 0;
              END
            ELSE
              BEGIN
                CoordError := True;
                Exit;
              END;
            WHILE ParseString[i] IN ['0'..'9'] DO
              BEGIN
                Argument4[k] := ParseString[i];
                k := k+1;
                DigitCount := DigitCount+1;
                i := i+1;
              END;
            Argument4[0] := Char(DigitCount);
          END;                {if}
        i := i+1;
      END;                    {while}
    ClearString;
    CoordError := False;
  END;                        {GetFourArguments}

  PROCEDURE ConvertArguments;
  VAR
    ErrCode, ErrCode1, ErrCode2, ErrCode3 : Integer;
  BEGIN
    Val(Argument1, Arg1, ErrCode);
    Val(Argument2, Arg2, ErrCode1);
    Val(Argument3, Arg3, ErrCode2);
    Val(Argument4, Arg4, ErrCode3);
  END;                        {ConvertArguments}

  FUNCTION HexStringToByte : Byte;
  VAR
    i : Integer;
    tmp : Byte;
  BEGIN
    i := Length(Argument);
    IF Argument[i] IN ['A'..'F'] THEN
      tmp := Ord(Argument[i])-55
    ELSE
      tmp := Ord(Argument[i])-48;
    i := i-1;
    IF i <> 0 THEN
      BEGIN
        IF Argument[i] IN ['A'..'F'] THEN
          HexStringToByte := tmp+(Ord(Argument[i])-55)*16
        ELSE
          HexStringToByte := tmp+(Ord(Argument[i])-48)*16;
      END;
    hex := False;
  END;                        {HexStringToByte}

  PROCEDURE DoBack;
  VAR
    {  value : byte; }
    ErrCode : Integer;
  BEGIN
    GetArgument;
    IF hex = True THEN
      Background := HexStringToByte
    ELSE
      BEGIN
        Val(Argument, Arg, ErrCode);
        Background := Arg;
      END;
    SetBackFore(Background, ForeGround);
    ClearArg(1);
    IF list = False THEN
      AddToList;
    ClearString;
  END;                        {DoBack}

  PROCEDURE DoBBM;
  BEGIN
    IF Length(CommandString) = 3 THEN
      GetBBM(LastX, LastY)
    ELSE
      BEGIN
        GetTwoArguments;
        ConvertArguments;
        GetBBM(Arg1, Arg2);
      END;
    BBMState := DataToByteString(BackgroundBitMask);
    Position(78, 24);
    WriteActStat;
    TextString(BBMState);
    RestoreState;
    ClearArg(2);
    IF list = False THEN
      AddToList;
    ClearString;
  END;                        {DoBBM}

  PROCEDURE Comment;
  BEGIN
    IF list = False THEN
      AddToList;
    ClearString;
  END;                        {Comment}

  PROCEDURE DoDontCare;
  VAR
    ErrCode : Integer;
  BEGIN
    GetArgument;
    IF hex = True THEN
      SetNoCare(HexStringToByte)
    ELSE
      BEGIN
        Val(Argument, Arg, ErrCode);
        SetNoCare(Arg);
      END;
    ClearArg(1);
    IF list = False THEN
      AddToList;
    ClearString;
  END;                        {DoDontCare}

  PROCEDURE DoDraw;
  BEGIN
    GetTwoArguments;
    IF CoordError = False THEN
      BEGIN
        ConvertArguments;
        IF Arg1 > 599 THEN
          BEGIN
            ClearStatus;
            Position(12, 24);
            WriteActStat;
            TextString('Error - destination X coordinate out of range');
            RestoreState;
            Exit;
          END;
        IF Arg2 > 274 THEN
          BEGIN
            ClearStatus;
            Position(12, 24);
            WriteActStat;
            TextString('Error - destination Y coordinate out of range');
            RestoreState;
            Exit;
          END;
        DrawLine(LastX, LastY, Arg1, Arg2);
        LastX := Arg1;
        Lasty := Arg2;
        ClearArg(2);
        IF list = False THEN
          AddToList;
      END                     {if}
    ELSE
      CommandError := True;
    ClearString;
  END;                        {DoDraw}

  PROCEDURE DoDisp;
  VAR
    ErrCode : Integer;
  BEGIN
    GetArgument;
    IF hex = True THEN
      SetDisp(HexStringToByte)
    ELSE
      BEGIN
        Val(Argument, Arg, ErrCode);
        SetDisp(Arg);
      END;
    ClearArg(1);
    IF list = False THEN
      AddToList;
    ClearString;
  END;                        {DoDisp}

  PROCEDURE Echo;
  BEGIN
    IF list = False THEN
      AddToList
    ELSE
      BEGIN
        WriteActStat;
        Position(12, 24);
        TextString(CommandString);
        Read(Kbd, ch);
        ClearStatus;
        RestoreState;
      END;
    ClearString;
  END;                        {Echo}

  PROCEDURE DoFreeze;
  VAR
    ErrCode : Integer;
  BEGIN
    GetArgument;
    IF hex = True THEN
      SetFreeze(HexStringToByte)
    ELSE
      BEGIN
        Val(Argument, Arg, ErrCode);
        SetFreeze(Arg);
      END;
    ClearArg(1);
    IF list = False THEN
      AddToList;
    ClearString;
  END;                        {DoFreeze}

  PROCEDURE DoForeground;
  VAR
    ErrCode : Integer;
  BEGIN
    GetArgument;
    IF hex = True THEN
      Foreground := HexStringToByte
    ELSE
      BEGIN
        Val(Argument, Arg, ErrCode);
        Foreground := Arg;
      END;
    SetBackFore(Background, Foreground);
    ClearArg(1);
    IF list = False THEN
      AddToList;
    ClearString;
  END;                        {DoForeground}

  PROCEDURE DoLatch;
  VAR
    value : Byte;
    ErrCode : Integer;
  BEGIN
    GetArgument;
    IF hex = True THEN
      value := HexStringToByte
    ELSE
      BEGIN
        Val(Argument, Arg, ErrCode);
        IF Arg > 255 THEN
          BEGIN
            ClearStatus;
            WriteActStat;
            Position(12, 24);
            TextString('Error - LatchProtect value out of range');
            RestoreState;
            Exit;
          END;
        value := Arg;
      END;
    SetLatchProtect(value);
    ClearArg(1);
    IF list = False THEN
      AddToList;
    ClearString;
  END;                        {DoLatch}

  PROCEDURE DoLine;
  BEGIN
    GetFourArguments;
    IF CoordError = False THEN
      BEGIN
        ConvertArguments;
        IF Arg1 > 575 THEN
          BEGIN
            ClearStatus;
            Position(12, 24);
            WriteActStat;
            TextString('Error - first X coordinate out of range');
            RestoreState;
            Exit;
          END;
        IF Arg2 > 270 THEN
          BEGIN
            ClearStatus;
            Position(12, 24);
            WriteActStat;
            TextString('Error - first Y coordinate out of range');
            RestoreState;
            Exit;
          END;
        IF Arg3 > 575 THEN
          BEGIN
            ClearStatus;
            Position(12, 24);
            WriteActStat;
            TextString('Error - second X coordinate out of range');
            RestoreState;
            Exit;
          END;
        IF Arg4 > 270 THEN
          BEGIN
            ClearStatus;
            Position(12, 24);
            WriteActStat;
            TextString('Error - second Y coordinate out of range');
            RestoreState;
            Exit;
          END;
        DrawLine(Arg1, Arg2, Arg3, Arg4);
        LastX := Arg3;
        LastY := Arg4;
        ClearArg(4);
        IF list = False THEN
          AddToList;
      END                     {if}
    ELSE
      CommandError := True;
    ClearString;
  END;                        {DoLine}

  PROCEDURE DoPalette;
  BEGIN
    GetTwoArguments;
    ConvertArguments;
    IF Arg1 > 15 THEN
      BEGIN
        ClearStatus;
        Position(12, 24);
        WriteActStat;
        TextString('Error - Palette index out of range');
        RestoreState;
        Exit;
      END;
    IF Arg2 > 63 THEN
      BEGIN
        ClearStatus;
        Position(12, 24);
        WriteActStat;
        TextString('Error - Color value out of range');
        RestoreState;
        Exit;
      END;
    ChangePalette(Arg1, Arg2);
    ProgramPalette;
    ClearArg(2);
    IF list = False THEN
      AddToList;
    ClearString;
  END;                        {DoPalette}

  PROCEDURE DoPlot;
  BEGIN
    GetTwoArguments;
    IF CoordError = False THEN
      BEGIN
        ConvertArguments;
        IF Arg1 > 575 THEN
          BEGIN
            ClearStatus;
            Position(12, 24);
            WriteActStat;
            TextString('Error - X coordinate out of range');
            RestoreState;
            Exit;
          END;
        IF Arg2 > 270 THEN
          BEGIN
            ClearStatus;
            Position(12, 24);
            WriteActStat;
            TextString('Error - Y coordinate out of range');
            RestoreState;
            Exit;
          END;
        PlotPoint(Arg1, Arg2);
        LastX := Arg1;
        LastY := Arg2;
        ClearArg(2);
        IF list = False THEN
          AddToList;
      END                     {if}
    ELSE
      CommandError := True;
    ClearString;
  END;                        {DoPlot}

  PROCEDURE DoPut;
  BEGIN
    GetTwoArguments;
    IF CoordError = False THEN
      BEGIN
        ConvertArguments;
        IF Arg1 > 575 THEN
          BEGIN
            ClearStatus;
            Position(12, 24);
            WriteActStat;
            TextString('Error - X coordinate out of range');
            RestoreState;
            Exit;
          END;
        IF Arg2 > 270 THEN
          BEGIN
            ClearStatus;
            Position(12, 24);
            WriteActStat;
            TextString('Error - Y coordinate out of range');
            RestoreState;
            Exit;
          END;
        PutMask;
        ClearArg(2);
        IF list = False THEN
          AddToList;
      END                     {if}
    ELSE
      CommandError := True;
    ClearString;
  END;                        {DoPut}

  PROCEDURE DoMask;
  VAR
    ErrCode : Integer;
  BEGIN
    GetArgument;
    IF hex = True THEN
      Mask := HexStringToByte
    ELSE
      BEGIN
        Val(Argument, Arg, ErrCode);
        Mask := Arg;
      END;
    ClearArg(1);
    IF list = False THEN
      AddToList;
    ClearString;
  END;                        {DoMask}

  PROCEDURE RestorePalette;
  BEGIN
    InitializePaletteTable;
    ProgramPalette;
    ClearString;
  END;                        {RestorePalette}

  PROCEDURE DoWriteMode;
  VAR
    value : Byte;
    ErrCode : Integer;
  BEGIN
    GetArgument;
    IF hex = True THEN
      BEGIN
        value := HexStringToByte;
        SetWriteMode(value);
      END
    ELSE
      BEGIN
        Val(Argument, Arg, ErrCode);
        SetWriteMode(Arg);
      END;
    ClearArg(1);
    IF list = False THEN
      AddToList;
    ClearString;
  END;                        {DoWriteMode}

  PROCEDURE ResolveA;
  BEGIN
    CASE ParseString[2] OF
      'N' : BEGIN
              IF ParseString[3] = 'D' THEN
                BEGIN
                  DoAnd;
                  IF list = False THEN
                    AddToList;
                  ClearString;
                END
              ELSE
                CommandError := True;
            END;
    END;                      {case}
  END;                        {ResolveA}

  PROCEDURE ResolveB;
  BEGIN
    CASE ParseString[2] OF
      'A' : BEGIN
              IF ParseString[3] = 'C' THEN
                IF ParseString[4] = 'K' THEN
                  DoBack
                ELSE
                  CommandError := True
              ELSE
                CommandError := True;
            END;
      'B' : BEGIN
              IF ParseString[3] = 'M' THEN
                DOBBM
              ELSE
                CommandError := True;
            END;
    END;                      {case}
  END;                        {ResolveB}

  PROCEDURE ResolveD;
  BEGIN
    CASE ParseString[4] OF
      'T' : BEGIN
              IF ParseString[2] = 'O' THEN
                IF ParseString[3] = 'N' THEN
                  DoDontCare
                ELSE
                  CommandError := True
              ELSE
                CommandError := True;
            END;
      'W' : BEGIN
              IF ParseString[2] = 'R' THEN
                IF ParseString[3] = 'A' THEN
                  DoDraw
                ELSE
                  CommandError := True
              ELSE
                CommandError := True;
            END;
      'P' : BEGIN
              IF ParseString[2] = 'I' THEN
                IF ParseString[3] = 'S' THEN
                  DoDisp
                ELSE
                  CommandError := True
              ELSE
                CommandError := True;
            END;
      'A' : BEGIN
              IF ParseString[2] = 'I' THEN
                IF ParseString[3] = 'S' THEN
                  IF ParseString[5] = 'B' THEN
                    IF ParseString[6] = 'L' THEN
                      IF ParseString[7] = 'E' THEN
                        BEGIN
                          DisablePalette;
                          IF list = False THEN
                            AddToList;
                          ClearString;
                        END
                      ELSE
                        CommandError := True
                    ELSE
                      CommandError := True
                  ELSE
                    CommandError := True
                ELSE
                  CommandError := True
              ELSE
                CommandError := True;
            END;
    END;                      {case}
  END;                        {ResolveD}

  PROCEDURE ResolveE;
  BEGIN
    CASE ParseString[2] OF
      'N' : BEGIN
              IF ParseString[3] = 'A' THEN
                IF ParseString[4] = 'B' THEN
                  IF ParseString[5] = 'L' THEN
                    IF ParseString[6] = 'E' THEN
                      BEGIN
                        EnablePalette;
                        IF list = False THEN
                          AddToList;
                        ClearString;
                      END
                    ELSE
                      CommandError := True
                  ELSE
                    CommandError := True
                ELSE
                  CommandError := True
              ELSE
                CommandError := True;
            END;
      'R' : BEGIN
              IF ParseString[3] = 'A' THEN
                IF ParseString[4] = 'S' THEN
                  IF ParseString[5] = 'E' THEN
                    BEGIN
                      Erase;
                      IF list = False THEN
                        AddToList;
                      ClearString;
                    END
                  ELSE
                    CommandError := True
                ELSE
                  CommandError := True
              ELSE
                CommandError := True;
            END;
    END;                      {Case}
  END;                        {ResolveE}

  PROCEDURE ResolveF;
  BEGIN
    CASE ParseString[3] OF
      'E' : BEGIN
              IF ParseString[2] = 'R' THEN
                IF ParseString[4] = 'E' THEN
                  IF ParseString[5] = 'Z' THEN
                    IF ParseString[6] = 'E' THEN
                      DoFreeze
                    ELSE
                      CommandError := True
                  ELSE
                    CommandError := True
                ELSE
                  CommandError := True
              ELSE
                CommandError := True;
            END;
      'L' : BEGIN
              IF ParseString[2] = 'I' THEN
                IF ParseString[4] = 'L' THEN
                  BEGIN
                    Fill;
                    IF list = False THEN
                      AddToList;
                    ClearString;
                  END
                ELSE
                  CommandError := True
              ELSE
                CommandError := True;
            END;
      'R' : BEGIN
              IF ParseString[2] = 'O' THEN
                IF ParseString[4] = 'E' THEN
                  DoForeground
                ELSE
                  CommandError := True
              ELSE
                CommandError := True;
            END;
    END;                      {Case}
  END;                        {ResolveF}

  PROCEDURE ResolveL;
  BEGIN
    CASE ParseString[3] OF
      'T' : BEGIN
              IF ParseString[2] = 'A' THEN
                IF ParseString[4] = 'C' THEN
                  IF ParseString[5] = 'H' THEN
                    DoLatch
                  ELSE
                    CommandError := True
                ELSE
                  CommandError := True
              ELSE
                CommandError := True;
            END;
      'N' : BEGIN
              IF ParseString[2] = 'I' THEN
                IF ParseString[4] = 'E' THEN
                  DoLine
                ELSE
                  CommandError := True
              ELSE
                CommandError := True;
            END;
      'S' : BEGIN
              IF ParseString[2] = 'I' THEN
                IF ParseString[4] = 'T' THEN
                  WriteDisplayList
                ELSE
                  CommandError := True
              ELSE
                CommandError := True;
            END;
    END;                      {case}
  END;                        {ResolveL}

  PROCEDURE ResolveP;
  BEGIN
    CASE ParseString[3] OF
      'L' : BEGIN
              IF ParseString[2] = 'A' THEN
                IF ParseString[4] = 'E' THEN
                  IF ParseString[5] = 'T' THEN
                    IF ParseString[6] = 'T' THEN
                      IF ParseString[7] = 'E' THEN
                        DoPalette
                      ELSE
                        CommandError := True
                    ELSE
                      CommandError := True
                  ELSE
                    CommandError := True
                ELSE
                  CommandError := True
              ELSE
                CommandError := True;
            END;
      'O' : BEGIN
              IF ParseString[2] = 'L' THEN
                IF ParseString[4] = 'T' THEN
                  DoPlot
                ELSE
                  CommandError := True
              ELSE
                CommandError := True;
            END;
      'T' : BEGIN
              IF ParseString[2] = 'U' THEN
                DoPut
              ELSE
                CommandError := True;
            END;
      'U' : BEGIN
              IF ParseString[2] = 'A' THEN
                IF ParseString[4] = 'S' THEN
                  IF ParseString[5] = 'E' THEN
                    BEGIN
                      Pause;
                      IF list = False THEN
                        AddToList;
                      ClearString;
                    END
                  ELSE
                    CommandError := True
                ELSE
                  CommandError := True
              ELSE
                CommandError := True;
            END;
    END;                      {case}
  END;                        {ResolveP}

  PROCEDURE ResolveR;
  BEGIN
    CASE ParseString[4] OF
      'E' : BEGIN
              IF ParseString[2] = 'E' THEN
                IF ParseString[3] = 'S' THEN
                  IF ParseString[5] = 'T' THEN
                    BEGIN
                      DoReset;
                      IF list = False THEN
                        AddToList;
                      ClearString;
                    END
                  ELSE
                    CommandError := True
                ELSE
                  CommandError := True
              ELSE
                CommandError := True;
            END;
      'D' : BEGIN
              IF ParseString[2] = 'E' THEN
                IF ParseString[3] = 'A' THEN
                  BEGIN
                    list := True;
                    ReadDisplayList;
                    list := False;
                  END
                ELSE
                  CommandError := True
              ELSE
                CommandError := True;
            END;
      'T' : BEGIN
              IF ParseString[2] = 'E' THEN
                IF ParseString[3] = 'S' THEN
                  IF ParseString[5] = 'O' THEN
                    IF ParseString[6] = 'R' THEN
                      IF ParseString[7] = 'E' THEN
                        BEGIN
                          RestorePalette;
                          IF list = False THEN
                            AddToList;
                          ClearString
                        END
                      ELSE
                        CommandError := True
                    ELSE
                      CommandError := True
                  ELSE
                    CommandError := True
                ELSE
                  CommandError := True
              ELSE
                CommandError := True;
            END;
    END;                      {case}
  END;                        {ResolveR}

  PROCEDURE Match;
  BEGIN
    UpCaseString;
    RemoveSpace;
    CASE ParseString[1] OF
      '*' : Comment;
      '!' : Echo;
      'A' : ResolveA;
      'B' : ResolveB;
      'C' : BEGIN
              IF ParseString[2] = 'L' THEN
                IF ParseString[3] = 'E' THEN
                  IF ParseString[4] = 'A' THEN { Explanation - the CLEAR   }
                    IF ParseString[5] = 'R' THEN { command actually SETS the }
                      BEGIN   { Mask Polarity Bit, CLEAR  }
                        SetPolarity; { refers to the bits in the }
                        IF list = False THEN { BBM which are cleared if  }
                          AddToList; { the pixel in question     }
                        ClearString; { equals the background     }
                      END     { color.                    }
                    ELSE
                      CommandError := True
                  ELSE
                    CommandError := True
                ELSE
                  CommandError := True
              ELSE
                CommandError := True;
            END;
      'D' : ResolveD;
      'E' : ResolveE;
      'F' : ResolveF;
      'L' : ResolveL;
      'M' : BEGIN
              IF ParseString[2] = 'A' THEN
                IF ParseString[3] = 'S' THEN
                  IF ParseString[4] = 'K' THEN
                    DoMask
                  ELSE
                    CommandError := True
                ELSE
                  CommandError := True
              ELSE
                CommandError := True;
            END;
      'O' : BEGIN
              IF ParseString[2] = 'R' THEN
                BEGIN
                  DoOR;
                  IF list = False THEN
                    AddToList;
                  ClearString;
                END
              ELSE
                CommandError := True;
            END;
      'P' : ResolveP;
      'Q' : BEGIN
              IF ParseString[2] = 'U' THEN
                IF ParseString[3] = 'I' THEN
                  IF ParseString[4] = 'T' THEN
                    BEGIN
                      ExitFlag := True;
                      ClearStatus;
                      WriteActStat;
                      Position(12, 24);
                      TextString('So Long');
                      RestoreState;
                      Delay(500);
                      Exit;
                    END
                  ELSE
                    ClearStatus;
              WriteActStat;
              Position(12, 24);
              TextString('Are you sure?  Enter Y to confirm exit.');
              RestoreState;
              ClearAction;
              Position(12, 22);
              Read(Kbd, ch);
              ClearStatus;
              UpCaseString;
              IF UpCase(ch) = 'Y' THEN
                BEGIN
                  ExitFlag := True;
                  Exit;
                END;
            END;
      'R' : ResolveR;
      'S' : BEGIN
              IF ParseString[2] = 'E' THEN
                IF ParseString[3] = 'T' THEN { Explanation - here SET refers }
                  BEGIN       { to the bits in the BBM that   }
                    ClearPolarity; { are equal to the background   }
                    IF list = False THEN { color value. The Mask         }
                      AddToList; { Polarity bit is actually      }
                    ClearString; { cleared by this command.      }
                  END
                ELSE
                  CommandError := True
              ELSE
                CommandError := True;
            END;
      'W' : BEGIN
              IF ParseString[2] = 'R' THEN
                IF ParseString[3] = 'I' THEN
                  IF ParseString[4] = 'T' THEN
                    IF ParseString[5] = 'E' THEN
                      DoWriteMode
                    ELSE
                      CommandError := True
                  ELSE
                    CommandError := True
                ELSE
                  CommandError := True
              ELSE
                CommandError := True;
            END;
      'X' : BEGIN
              IF ParseString[2] = 'O' THEN
                IF ParseString[3] = 'R' THEN
                  BEGIN
                    DoXOR;
                    IF list = False THEN
                      AddToList;
                    ClearString;
                  END
                ELSE
                  CommandError := True
              ELSE
                CommandError := True;
            END;
      'Z' : BEGIN
              IF ParseString[2] = 'A' THEN
                IF ParseString[3] = 'P' THEN
                  ZapList
                ELSE
                  CommandError := True
              ELSE
                CommandError := True;
            END
    ELSE
      IF ParseString[0] <> Char(0) THEN
        BEGIN
          ClearStatus;
          WriteActStat;
          Position(12, 24);
          TextString('Sorry, unrecognizable command');
          RestoreState;
          Read(Kbd, ch);
          ClearAction;
          ClearStatus;
        END;
    END;                      {Case}
  END;                        {Match}
