PROGRAM Learn222;

  {$U-}
  {$C-}

TYPE
  GraphicsChar = ARRAY[0..15] OF Byte;
  Font = ARRAY[0..255] OF GraphicsChar;
  ValueTable = ARRAY[0..11] OF Byte;
  ArgString = STRING[4];
  NibbleString = STRING[4];
  ByteString = STRING[8];
  Tstring = STRING[64];

  ListPointer = ^ListRecord;

  ListRecord = RECORD
                 Command : STRING[40];
                 Next : ListPointer;
               END;
CONST
  DMCPort = $03B8;
  IndexReg = $03B4;
  DataReg = $03B5;
  ScreenSize = $8000;
  CharacterFile = 'LEARN.FNT';

  Result : ARRAY[0..15] OF NibbleString = ('0000', '0001', '0010', '0011',
    '0100', '0101', '0110', '0111', '1000', '1001', '1010', '1011', '1100', '1101',
    '1110', '1111');
VAR
  xText, yText, LineSpacing, BufferStart : Integer;
  Arg, Arg1, Arg2, Arg3, Arg4, LastX, LastY : Integer;
  OldConOutPtr : Integer;
  Mask, PlotMode, BackgroundBitMask, CharHeight : Byte;
  ch : Char;
  List, ErrorFlag, CommandError, CoordError, ExitFlag, Hex : Boolean;
  CharData : Font;
  YTable : ARRAY[0..347] OF Integer;

  HeapTop : ^Integer;
  FileName : STRING[66];
  FirstCommand, LastCommand, NewCommand : ListPointer;
  FreeSpace : Real;
  DisplayList : Text;

  CommandString : STRING[40];
  ParseString : STRING[40];
  Argument : STRING[5];
  Argument1 : STRING[3];
  Argument2 : STRING[3];
  Argument3 : STRING[3];
  Argument4 : STRING[3];

  PaletteState, PolarityState : Char;
  FreezeState, DispState, WriteModeState : NibbleString;
  NoCareState, BackState, ForeState : NibbleString;
  LatchProtectState, BBMState : ByteString;

  Foreground, Background, Bck : Byte;
  Reg17h, Reg18h, Reg19h, Reg1ah, Reg1bh, Reg1ch : Byte;

  PaletteTable : ARRAY[0..15] OF Byte;

  {$I LOWLEVEL.INC}

  FUNCTION DataToNibbleString(Data : Byte) : NibbleString;
  BEGIN
    DataToNibbleString := Result[Data];
  END;                        {DataToNibbleString}

  FUNCTION DataToByteString(Data : Byte) : ByteString;
  VAR
    HighNibble, LowNibble, HN, Ln : Byte;
    TempStrHigh, TempStrLow : NibbleString;
  BEGIN
    HN := Data;
    Ln := Data;
    HighNibble := HN SHR 4;
    LowNibble := Ln AND $0f;
    TempStrHigh := Result[HighNibble];
    TempStrLow := Result[LowNibble];
    DataToByteString := TempStrHigh+TempStrLow;
  END;                        {DataToByteString}

  PROCEDURE To6845(Regnum, value : Byte);
  BEGIN
    Port[IndexReg] := Regnum;
    Port[DataReg] := value;
  END;

  PROCEDURE WriteSettings;
  VAR
    TmpReg18h : Byte;
  BEGIN
    TmpReg18h := Reg18h SHL 4; { Temporarily "unfreeze" all planes }
    TmpReg18h := TmpReg18h SHR 4; { but preserve Display Planes state }
    To6845($18, TmpReg18h);
    To6845($19, $00);
    To6845($1A, $17);
    To6845($1B, $00);
  END;                        {WriteSettings}

  PROCEDURE WriteActStat;
  VAR
    TmpReg18h : Byte;
  BEGIN
    TmpReg18h := Reg18h SHL 4; { Temporarily "unfreeze" all planes }
    TmpReg18h := TmpReg18h SHR 4; { but preserve Display Planes state }
    To6845($18, TmpReg18h);
    To6845($19, $00);
    To6845($1A, $74);
    To6845($1B, $00);
  END;                        {WriteActStat}

  PROCEDURE RestoreState;     { After updating simulator, restores registers }
  BEGIN
    To6845($18, Reg18h);
    To6845($19, Reg19h);
    To6845($1A, Reg1Ah);
    To6845($1B, Reg1Bh);
  END;                        {RestoreState}

  PROCEDURE ClearAction;
  BEGIN
    WriteActStat;
    Position(12, 22);
    TextString('                                                  ');
    RestoreState;
  END;                        {ClearAction}

  PROCEDURE ClearStatus;
  BEGIN
    WriteActStat;
    Position(12, 24);
    TextString('                                                  ');
    RestoreState;
  END;                        {ClearStatus}

  PROCEDURE AddToList;
  BEGIN
    FreeSpace := MaxAvail;
    IF FreeSpace < 0.0 THEN
      FreeSpace := FreeSpace+65536.0;
    IF FreeSpace > 10.0 THEN
      BEGIN
        CommandString := Concat(CommandString, #13, #10);
        New(NewCommand);
        NewCommand^.Command := CommandString;
        IF FirstCommand = NIL THEN
          FirstCommand := NewCommand
        ELSE
          LastCommand^.Next := NewCommand;
        LastCommand := NewCommand;
        LastCommand^.Next := NIL;
      END
    ELSE
      BEGIN
        ClearStatus;
        Position(12, 24);
        WriteActStat;
        TextString('Memory Full - Save Your Display List !');
        Read(Kbd, ch);
        RestoreState;
      END;
  END;                        {AddToList}

  PROCEDURE SetBackFore(Bk, Fg : Byte);
  BEGIN
    IF Bk > 15 THEN
      BEGIN
        ClearStatus;
        Position(12, 24);
        WriteActStat;
        TextString('Error - Background value out of range');
        RestoreState;
        Exit;
      END;
    IF Fg > 15 THEN
      BEGIN
        ClearStatus;
        Position(12, 24);
        WriteActStat;
        TextString('Error - Foreground value out of range');
        RestoreState;
        Exit;
      END;
    Background := Bk; Foreground := Fg;
    Reg1ah := (Bk SHL 4)+Fg;
    Port[IndexReg] := $1a;
    Port[DataReg] := Reg1ah;
    BackState := DataToNibbleString(Background);
    ForeState := DataToNibbleString(Foreground);
    WriteSettings;
    Position(6, 13); TextString(BackState);
    Position(6, 15); TextString(ForeState);
    RestoreState;
  END;                        {SetBackFore}

  PROCEDURE SetFreeze(value : Byte);
  VAR
    TmpVal : Byte;
  BEGIN
    IF value > 15 THEN
      BEGIN
        ClearStatus;
        Position(12, 24);
        WriteActStat;
        TextString('Error - Freeze value out of range');
        RestoreState;
        Exit;
      END;
    TmpVal := value;
    TmpVal := TmpVal SHL 4;
    Reg18h := Reg18h AND $0F;
    Reg18h := Reg18h OR TmpVal;
    Port[IndexReg] := $18;
    Port[DataReg] := Reg18h;
    FreezeState := DataToNibbleString(Value);
    WriteSettings;
    Position(6, 5); TextString(FreezeState);
    RestoreState;
  END;                        {SetFreeze}

  PROCEDURE SetDisp(value : Byte);
  BEGIN
    IF value > 15 THEN
      BEGIN
        ClearStatus;
        Position(12, 24);
        WriteActStat;
        TextString('Error - Display value out of range');
        RestoreState;
        Exit;
      END;
    Reg18h := Reg18h AND $F0;
    Reg18h := Reg18h+value;
    Port[IndexReg] := $18;
    Port[DataReg] := Reg18h;
    DispState := DataToNibbleString(value);
    WriteSettings;
    Position(6, 7); TextString(DispState);
    RestoreState;
  END;                        {SetDisp}

  PROCEDURE SetNoCare(value : Byte);
  BEGIN
    IF value > 15 THEN
      BEGIN
        ClearStatus;
        Position(12, 24);
        WriteActStat;
        TextString('Error - Don''t Care value out of range');
        RestoreState;
        Exit;
      END;
    Reg19h := Reg19h AND $F0;
    Reg19h := Reg19h+value;
    Port[IndexReg] := $19;
    Port[DataReg] := Reg19h;
    NoCareState := DataToNibbleString(value);
    WriteSettings;
    Position(6, 9); TextString(NoCareState);
    RestoreState;
  END;                        {SetNoCare}

  PROCEDURE SetPolarity;
  BEGIN
    Reg19h := Reg19h OR $40;
    Port[IndexReg] := $19;
    Port[DataReg] := Reg19h;
    PolarityState := '1';
    WriteSettings;
    Position(6, 11); TextString(PolarityState);
    RestoreState;
  END;                        {SetPolarity}

  PROCEDURE ClearPolarity;
  BEGIN
    Reg19h := Reg19h AND $3F;
    Port[IndexReg] := $19;
    Port[DataReg] := Reg19h;
    PolarityState := '0';
    WriteSettings;
    Position(6, 11); TextString(PolarityState);
    RestoreState;
  END;                        {ClearPolarity}

  PROCEDURE SetWriteMode(value : Byte);
  VAR
    TmpVal : Byte;
  BEGIN
    IF value > 3 THEN
      BEGIN
        ClearStatus;
        Position(12, 24);
        WriteActStat;
        TextString('Error - WriteMode value out of range');
        RestoreState;
        Exit;
      END;
    TmpVal := value;
    TmpVal := TmpVal SHL 4;
    Reg19h := Reg19h AND $CF;
    Reg19h := Reg19h OR TmpVal;
    Port[IndexReg] := $19;
    Port[DataReg] := Reg19h;
    WriteModeState := DataToNibbleString(value);
    Delete(WriteModeState, 1, 2);
    WriteSettings;
    Position(6, 17); TextString(WriteModeState);
    RestoreState;
  END;                        {SetWriteMode}

  PROCEDURE EnablePalette;
  BEGIN
    Reg17h := Reg17h OR $10;
    Port[IndexReg] := $17;
    Port[DataReg] := Reg17h;
    WriteSettings;
    Position(6, 3); TextString('1');
    RestoreState;
  END;                        {EnablePalette}

  PROCEDURE DisablePalette;
  BEGIN
    Reg17h := Reg17h AND $2F;
    Port[IndexReg] := $17;
    Port[DataReg] := Reg17h;
    WriteSettings;
    Position(6, 3); TextString('0');
    RestoreState;
  END;                        {DisablePalette}

  PROCEDURE InitializePaletteTable;
  BEGIN
    PaletteTable[0] := 0;
    PaletteTable[1] := 1;
    PaletteTable[2] := 2;
    PaletteTable[3] := 3;
    PaletteTable[4] := 4;
    PaletteTable[5] := 5;
    PaletteTable[6] := 6;
    PaletteTable[7] := 7;
    PaletteTable[8] := 24;
    PaletteTable[9] := 9;
    PaletteTable[10] := 10;
    PaletteTable[11] := 11;
    PaletteTable[12] := 12;
    PaletteTable[13] := 13;
    PaletteTable[14] := 14;
    PaletteTable[15] := 15;
  END;                        {InitializePaletteTable}

  PROCEDURE ProgramPalette;
  VAR
    I : Integer;
  BEGIN
    Port[IndexReg] := $1C;
    Reg1ch := Port[DataReg];  { Reset Palette Pointer }
    FOR I := 0 TO 15 DO
      Port[DataReg] := PaletteTable[I];
  END;                        {ProgramPalette}

  PROCEDURE ChangePalette(index, value : Byte);
  BEGIN
    PaletteTable[index] := value;
    ProgramPalette;
  END;                        {ChangePalette}

  PROCEDURE SetLatchProtect(value : Byte);
  BEGIN
    Reg1bh := value;
    Port[IndexReg] := $1b;
    Port[DataReg] := Reg1bh;
    LatchProtectState := DataToByteString(value);
    WriteSettings;
    Position(6, 19); TextString(LatchProtectState);
    RestoreState;
  END;                        {SetPixelProtect}

  PROCEDURE GetBBM(X, Y : Integer);
  VAR
    Address : Integer;
  BEGIN
    Y := Y+5;
    X := X+136;
    X := X DIV 8;
    Address := ScanLineAddr(Y)+X;
    BackGroundBitMask := Mem[$B000:Address];
  END;                        {GetBBM}

  PROCEDURE DoOR;
  BEGIN
    PlotMode := 0;
    Position(80, 22);
    WriteActStat;
    TextString(' OR ');
    RestoreState;
  END;                        {DoOR}

  PROCEDURE DoXOR;
  BEGIN
    PlotMode := 1;
    Position(79, 22);
    WriteActStat;
    TextString(' XOR ');
    RestoreState;
  END;                        {DoXOR}

  PROCEDURE DoAnd;
  BEGIN
    PlotMode := 2;
    Position(79, 22);
    WriteActStat;
    TextString(' AND ');
    RestoreState;
  END;                        {DoAnd}

  PROCEDURE Erase;
  VAR
    Y : Integer;
  BEGIN
    Y := 5;
    To6845($19, $00);
    To6845($1A, $00);
    To6845($1B, $00);
    FOR Y := Y TO 275 DO
      FillChar(Mem[$B000:Ytable[Y]+17], 72, $00);
    RestoreState;
  END;                        {Erase}

  PROCEDURE Fill;
  VAR
    Y : Integer;
  BEGIN
    Y := 5;
    To6845($19, $00);
    To6845($1A, $FF);
    To6845($1B, $00);
    FOR Y := Y TO 275 DO
      FillChar(Mem[$B000:Ytable[Y]+17], 72, $FF);
    RestoreState;
  END;                        {Fill}

  PROCEDURE FilledBlock(Y, Y1, Xstart : Integer; width : Byte);
  BEGIN
    FOR Y := Y TO Y1 DO
      FillChar(Mem[$B000:YTable[Y]+Xstart], width, $FF);
  END;                        {FilledBlock}

  PROCEDURE WriteInitialScreen;
  BEGIN
    WriteSettings;
    Position(3, 2); TextString('Palette '); Position(3, 3); TextString(' = ');
    Position(3, 4); TextString('Freeze '); Position(3, 5); TextString(' = ');
    Position(3, 6); TextString('Display '); Position(3, 7); TextString(' = ');
    Position(3, 8); TextString('Don''t Care '); Position(3, 9); TextString(' = ');
    Position(3, 10); TextString('MaskPolarity '); Position(3, 11); TextString(' = ');
    Position(3, 12); TextString('Background '); Position(3, 13); TextString(' = ');
    Position(3, 14); TextString('Foreground '); Position(3, 15); TextString(' = ');
    Position(3, 16); TextString('Write Mode '); Position(3, 17); TextString(' = ');
    Position(3, 18); TextString('LatchProtect '); Position(3, 19); TextString(' = ');
    WriteActStat;
    Position(3, 22); TextString('Action : ');
    Position(3, 24); TextString('Status : ');
    Position(67, 22); TextString('Plot Mode =');
    Position(70, 24); TextString('BBM =');
    Position(78, 24); TextString('00000000');
  END;                        {WriteInitialScreen}

  PROCEDURE DoReset;
  BEGIN
    SetWriteMode(0);
    EnablePalette;
    SetDisp(15);
    SetNoCare(0);
    SetFreeze(0);
    SetPolarity;
    SetBackFore(0, 15);
    SetLatchProtect(0);
    DoOR;
  END;                        {DoReset}

  PROCEDURE ConstructScreen;
  BEGIN
    SetBackFore(24, 24);
    SetWriteMode(0);
    FilledBlock(0, 4, 0, 90); { Top - Gray }
    FilledBlock(344, 347, 0, 90); { Bottom - Gray }
    FilledBlock(276, 280, 0, 90); { 2/3rds down - gray }
    FilledBlock(0, 347, 0, 1); { left edge - gray }
    FilledBlock(0, 347, 89, 1); { right edge - gray }
    FilledBlock(5, 280, 16, 1); { between settings and drawing area - gray }
    FilledBlock(281, 343, 62, 1); { between action,status, and plot,bbm }
    SetBackFore(1, 1);
    FilledBlock(5, 275, 1, 15); { Settings }
    SetBackFore(7, 7);
    FilledBlock(281, 343, 1, 61); { Action, Status}
    FilledBlock(281, 343, 63, 26);

    WriteInitialScreen;
    SetWriteMode(0);
    WriteSettings;
    EnablePalette;
    SetDisp(15);
    SetNoCare(0);
    SetFreeze(0);
    SetPolarity;
    SetBackFore(0, 15);
    SetLatchProtect(0);
    DoOR;
  END;                        {ConstructScreen}

  PROCEDURE Reset222;
  BEGIN
    To6845($14, $00);
    To6845($17, $20);
    To6845($18, $0F);
    To6845($19, $40);
    To6845($1A, $0F);
    To6845($1B, $00);
  END;                        {Reset222}

  PROCEDURE FileError;
  BEGIN
    ClearStatus;
    Position(12, 24);
    WriteActStat;
    TextString('Error accessing the specified file');
    Read(Kbd, ch);
  END;                        {FileError}

  PROCEDURE WriteDisplayList;
  BEGIN
    IF FirstCommand = NIL THEN
      BEGIN
        ClearStatus;
        Position(12, 24);
        WriteActStat;
        TextString('Display List is empty - nothing to save.');
        Read(Kbd, ch);
        RestoreState;
        ClearStatus;
        Exit;
      END;
    ClearStatus;
    ClearAction;
    Position(12, 24);
    WriteActStat;
    TextString('Enter a file name for the display list');
    Position(12, 22);
    TextString('_');
    Position(12, 22);
    Read(FileName);
    ClearAction;
    ClearStatus;
    RestoreState;

    {$I-}

    Assign(DisplayList, FileName);
    IF IOResult <> 0 THEN
      BEGIN
        FileError;
        Exit;
      END;

    Rewrite(DisplayList);
    IF IOResult <> 0 THEN
      BEGIN
        FileError;
        Exit;
      END;

    {$I+}

    WHILE FirstCommand <> NIL DO
      WITH FirstCommand^ DO
        BEGIN
          Write(DisplayList, Command);
          FirstCommand := Next;
        END;
    Close(DisplayList);
    Release(HeapTop);
    FirstCommand := NIL;
  END;                        {WriteDisplayList}

  PROCEDURE ZapList;
  BEGIN
    Release(HeapTop);
    FirstCommand := NIL;
  END;                        {ZapList}

  PROCEDURE Match; FORWARD;

  PROCEDURE ReadDisplayList;
  BEGIN
    ClearStatus;
    Position(12, 24);
    WriteActStat;
    TextString('Enter the display list file name');
    ClearAction;
    WriteActStat;
    Position(12, 22);
    TextString('_');
    Position(12, 22);
    Read(FileName);
    ClearAction;
    ClearStatus;
    RestoreState;

    {$I-}

    Assign(DisplayList, FileName);
    IF IOResult <> 0 THEN
      BEGIN
        FileError;
        Exit;
      END;

    Reset(DisplayList);
    IF IOResult <> 0 THEN
      BEGIN
        FileError;
        Exit;
      END;

    {$I+}

    WHILE NOT EoF(DisplayList) DO
      BEGIN
        ReadLn(DisplayList, CommandString);
        Match;
      END;
    Close(DisplayList);
  END;                        {ReadDisplayList}

  PROCEDURE Pause;
  BEGIN
    IF list = True THEN
      BEGIN
        ClearStatus;
        Position(12, 24);
        WriteActStat;
        TextString('Strike a key to continue processing list');
        Read(Kbd, ch);
        ClearStatus;
        RestoreState;
      END;
  END;                        {Pause}

  {$I INPUT.INC}

  PROCEDURE Initialize;
  VAR
    FontFile : FILE OF Font;
    I : Integer;
  BEGIN
    FOR I := 0 TO 347 DO
      YTable[I] := ScanLineAddr(I);
    Assign(FontFile, CharacterFile);
    {$I-}
    Reset(FontFile);
    {$I+}
    IF IOResult = 0 THEN
      BEGIN
        Read(FontFile, CharData);
        Close(FontFile);
      END
    ELSE
      BEGIN
        ErrorFlag := True;
        Exit;
      END;
    ErrorFlag := False;
    ExitFlag := False;
    LineSpacing := 14;
    CharHeight := 14;
    PlotMode := 0;
    BufferStart := $B000;
    OldConOutPtr := ConOutPtr;
    ConOutPtr := Ofs(EchoInput);
    ClearArg(1);
    ClearArg(2);
    ClearArg(4);
    ClearString;
    LastX := 0; LastY := 0;
    List := False;

    FirstCommand := NIL;
    Mark(HeapTop);

    Reset222;
    InitializePaletteTable;
    ProgramPalette;
    SetGraphics;
    Port[DMCPort] := 2;       {video off - graphics mode}
    ClearScreen;
    Reg18h := $0F;
    Reg19h := $00;
    Reg1Ah := $88;
    Reg1Bh := $00;
    EnablePalette;
    SetWriteMode(0);
    ConstructScreen;
    Port[DMCPort] := 10;      {video on - graphics mode}
  END;                        {Initialize}

  PROCEDURE RestoreText;
  BEGIN
    SetText;
    ConOutPtr := OldConOutPtr;
  END;                        {RestoreText}

  PROCEDURE WriteTitleScreen;
  BEGIN
    To6845($19, $0F);
    To6845($1A, $04);
    Position(44, 6); TextString('Welcome To The');
    To6845($1A, $02);
    Position(40, 8); TextString('Hercules InColor Card');
    To6845($1A, $05);
    Position(42, 10); TextString('Simulation Program');
    To6845($1A, $03);
    Position(41, 16);
    TextString('Press a Key to Begin');
    To6845($1A, $01);
    Position(26, 19);
    TextString('Copyright (C) 1987 Hercules Computer Technology, Inc.');
    Read(Kbd, ch);
    Erase;
    RestoreState;
  END;                        {WriteTitleScreen}

BEGIN                         {Learn222}
  Initialize;
  IF ErrorFlag THEN
    BEGIN
      WriteLn('ERROR - cannot load font file : LEARN.FNT');
      WriteLn('The LEARN.FNT file must be in the default drive/directory.');
      Exit;
    END;
  WriteTitleScreen;
  WHILE ExitFlag = False DO
    BEGIN
      CommandError := False;
      ClearAction;
      WriteActStat;
      Position(12, 22);
      TextString('_');
      Position(12, 22);
      Read(CommandString);
      ClearStatus;
      RestoreState;
      Match;
      IF CommandError = True THEN
        BEGIN
          WriteActStat;
          Position(12, 24);
          TextString('Command Syntax Error');
          Read(Kbd, ch);
          RestoreState;
          ClearStatus;
        END;
    END;                      {while}
  Release(HeapTop);
  Reset222;
  RestoreText;
END.                          {Learn222}
