  {LOWLEVEL.INC}

  FUNCTION ScanLineAddr(Y : Integer) : Integer;
  BEGIN
    ScanLineAddr := (Y AND 3) SHL 13+90*(Y SHR 2);
  END;                        {ScanLineAddr}

  PROCEDURE Position(X, Y : Integer);
  BEGIN
    xText := X;
    yText := Y;
  END;                        {Position}

  PROCEDURE ClearScreen;
  BEGIN
    FillChar(Mem[BufferStart:0000], ScreenSize, 0);
  END;                        {ClearScreen}

  PROCEDURE SetGraphics;
  CONST
    GraphTable : ValueTable =
    ($35, $2D, $2E, $07, $5B, $02, $57, $57, $02, $03, $00, $00);
  BEGIN
    Port[$03BF] := 1;         {   sets the GB222 to HALF           }
    INLINE(
      $B0/$02                 {      mov     al,2                  }
      /$BA/DMCPort            {      mov     dx,DMCPort            }
      /$EE                    {      out     dx,al                 }
      /$1E                    {      push    ds                    }
      /$0E                    {      push    cs                    }
      /$1F                    {      pop     ds                    }
      /$BA/IndexReg           {      mov     dx,IndexReg           }
      /$B5/$0C                {      mov     ch,12                 }
      /$32/$E4                {      xor     ah,ah                 }
      /$33/$F6                {      xor     si,si                 }
      /$81/$C6/GraphTable     {      add     si,GraphTable         }
      /$8A/$C4                { Parm:mov     al,ah                 }
      /$EE                    {      out     dx,al                 }

      /$42                    {      inc     dx                    }
      /$AC                    {      lodsb                         }
      /$EE                    {      out     dx,al                 }

      /$FE/$C4                {      inc     ah                    }
      /$4A                    {      dec     dx                    }
      /$FE/$CD                {      dec     ch                    }
      /$75/$F3                {      jnz     Parm                  }
      /$1F                    {      pop     ds                    }

      /$B9/$4000              {      mov     cx,4000h              }
      /$B8/$B000              {      mov     ax,0B000h             }
      /$8E/$C0                {      mov     es,ax                 }
      /$FC                    {      cld                           }

      /$33/$FF                {      xor     di,di                 }
      /$33/$C0                {      xor     ax,ax                 }
      /$AB                    { clr: stosw                         }
      /$49                    {      dec     cx                    }
      /$75/$FC                {      jnz     clr                   }

      /$BA/DMCPort            {      mov     dx,DMCPort            }
      /$B0/$0A                {      mov     al,0ah                }
      /$EE)                   {      out     ax,al                 }
  END;                        {SetGraphics}

  PROCEDURE SetText;
  CONST
    TextTable : ValueTable =
    ($61, $50, $52, $0F, $19, $06, $19, $19, $02, $0D, $0B, $0C);
  BEGIN
    INLINE(
      $B0/$20                 {      mov     al,20h                }
      /$BA/DMCPort            {      mov     dx,DMCPort            }
      /$EE                    {      out     dx,al                 }
      /$1E                    {      push    ds                    }
      /$0E                    {      push    cs                    }
      /$1F                    {      pop     ds                    }
      /$BA/IndexReg           {      mov     dx,IndexReg           }
      /$B5/$0C                {      mov     ch,12                 }
      /$32/$E4                {      xor     ah,ah                 }
      /$33/$F6                {      xor     si,si                 }
      /$81/$C6/TextTable      {      add     si,TextTable          }
      /$8A/$C4                { Parm:mov     al,ah                 }
      /$EE                    {      out     dx,al                 }

      /$42                    {      inc     dx                    }
      /$AC                    {      lodsb                         }
      /$EE                    {      out     dx,al                 }

      /$FE/$C4                {      inc     ah                    }
      /$4A                    {      dec     dx                    }
      /$FE/$CD                {      dec     ch                    }
      /$75/$F3                {      jnz     Parm                  }
      /$1F                    {      pop     ds                    }
      /$B9/$07D0              {      mov     cx,2000               }
      /$B8/$B000              {      mov     ax,0B000h             }
      /$8E/$C0                {      mov     es,ax                 }
      /$FC                    {      cld                           }

      /$33/$FF                {      xor     di,di                 }
      /$B8/$0720              {      mov     ax,720h               }
      /$AB                    { clr: stosw                         }
      /$49                    {      dec     cx                    }
      /$75/$FC                {      jnz     clear                 }

      /$BA/DMCPort            {      mov     dx,DMCPort            }
      /$B0/$08                {      mov     al,8                  }
      /$EE)                   {      out     dx,al                 }
  END;                        {SetText}

  PROCEDURE MMask(X, Y : Integer);
  BEGIN
    INLINE(
      $8B/$46/< Y             {      mov     ax,Y                  }
      /$D1/$E0                {      shl     ax,1                  }
      /$97                    {      xchg    ax,di                 }
      /$8B/$85/YTable         {      mov     ax,[di+YTable]        }

      /$8B/$5E/< X            {      mov     bx,X                  }
      /$B1/$03                {      mov     cl,03                 }
      /$D3/$EB                {      shr     bx,cl                 }
      /$01/$C3                {      add     bx,ax                 }

      /$8A/$16/Mask           {      mov     dl,mask               }

      /$B8/$B000              {      mov     ax,0B000h             }
      /$8E/$C0                {      mov     es,ax                 }
      /$A0/PlotMode           {      mov     al,PlotMode           }
      /$3C/$00                {      cmp     al,0                  }
      /$74/$10                {      je      mm2                   }
      /$3C/$01                {      cmp     al,1                  }
      /$74/$06                {      je      mm1                   }
      /$26                    {      es:                           }
      /$20/$17                {      and     [bx],dl               }
      /$EB/$0A                {      jmp     done                  }
      /$90                    {      nop                           }
      /$26                    { mm1: es:                           }
      /$30/$17                {      xor     [bx],dl               }
      /$EB/$04                {      jmp     done                  }
      /$90                    {      nop                           }
      /$26                    { mm2: es:                           }
      /$08/$17);              {      or      [bx],dl               }
  END; {MMask}                { done:                              }

  PROCEDURE PutMask;
  VAR
    X, Y : Integer;
  BEGIN
    X := Arg1+136;
    Y := Arg2+5;
    MMask(X, Y);
  END;                        {PutMask}

  PROCEDURE MPlot(X, Y : Integer);
  BEGIN
    INLINE(
      $8B/$46/< Y             {      mov     ax,Y                  }
      /$D1/$E0                {      shl     ax,1                  }
      /$97                    {      xchg    ax,di                 }
      /$8B/$85/YTable         {      mov     ax,[di+YTable]        }

      /$8B/$5E/< X            {      mov     bx,X                  }
      /$89/$DA                {      mov     dx,bx                 }
      /$B1/$03                {      mov     cl,03                 }
      /$D3/$EB                {      shr     bx,cl                 }
      /$01/$C3                {      add     bx,ax                 }

      /$88/$D1                {      mov     cl,dl                 }
      /$80/$E1/$07            {      and     cl,07                 }
      /$B2/$80                {      mov     dl,80h                }
      /$D2/$EA                {      shr     dl,cl                 }

      /$B8/$B000              {      mov     ax,0B000h             }
      /$8E/$C0                {      mov     es,ax                 }
      /$A0/PlotMode           {      mov     al,PlotMode           }
      /$3C/$00                {      cmp     al,0                  }
      /$74/$10                {      je      pm2                   }
      /$3C/$01                {      cmp     al,1                  }
      /$74/$06                {      je      pm1                   }
      /$26                    {      es:                           }
      /$20/$17                {      and     [bx],dl               }
      /$EB/$0A                {      jmp     done                  }
      /$90                    {      nop                           }
      /$26                    { pm1: es:                           }
      /$30/$17                {      xor     [bx],dl               }
      /$EB/$04                {      jmp     done                  }
      /$90                    {      nop                           }
      /$26                    { pm2: es:                           }
      /$08/$17);              {      or      [bx],dl               }
  END; {MPlot}                { done:                              }

  PROCEDURE PlotPoint(X, Y : Integer);
  BEGIN
    X := X+136;               { Adjust coordinates to screen mapping for simulator }
    Y := Y+5;
    MPlot(X, Y);
  END;                        {PlotPoint}

  PROCEDURE DrawLine(X1, Y1, X2, Y2 : Integer);
  VAR
    X, Y, DX, DY, XS, YS, Step : Integer;
  BEGIN
    X1 := X1+136; X2 := X2+136; Y1 := Y1+5; Y2 := Y2+5;
    X := X1; Y := Y1;
    XS := 1; YS := 1;
    IF X1 > X2 THEN
      XS := -1;
    IF Y1 > Y2 THEN
      YS := -1;
    DX := Abs(X2-X1);
    DY := Abs(Y2-Y1);
    IF DX = 0 THEN
      Step := -1
    ELSE
      Step := 0;
    WHILE NOT((X = X2) AND (Y = Y2)) DO
      BEGIN
        MPlot(X, Y);
        IF Step < 0 THEN
          BEGIN
            Y := Y+YS;
            Step := Step+DX;
          END
        ELSE
          BEGIN
            X := X+XS;
            Step := Step-DY;
          END;
      END;
  END;                        {DrawLine}


  PROCEDURE DisplayChar(Chr : Byte);
  BEGIN
    INLINE(
      $A1/yText               {      mov     ax,yText              }
      /$48                    {      dec     ax                    }
      /$8B/$3E/LineSpacing    {      mov     di,LineSpacing        }
      /$F7/$E7                {      mul     di                    }
      /$D1/$E0                {      shl     ax,1                  }
      /$97                    {      xchg    ax,di                 }

      /$8A/$86/Chr            {      mov     al,chr                }
      /$30/$E4                {      xor     ah,ah                 }
      /$D1/$E0                {      shl     ax,1                  }
      /$D1/$E0                {      shl     ax,1                  }
      /$D1/$E0                {      shl     ax,1                  }
      /$D1/$E0                {      shl     ax,1                  }
      /$89/$C3                {      mov     bx,ax                 }
      /$81/$C3/CharData       {      add     bx,CharData           }
      /$8A/$16/xText          {      mov     dl,xText              }
      /$FE/$CA                {      dec     dl                    }
      /$B6/$00                {      mov     dh,00                 }

      /$A1/BufferStart        {      mov     ax,BufferStart        }
      /$8E/$C0                {      mov     es,ax                 }
      /$8A/$2E/CharHeight     {      mov     ch,CharHeight         }

      /$8B/$B5/YTable         { nxt: mov     si,[di+YTable]        }
      /$01/$D6                {      add     si,dx                 }

      /$8A/$07                {      mov     al,[bx]               }
      /$26                    {      es:                           }
      /$88/$04                {      mov     [si],al               }
      /$43                    {      inc     bx                    }
      /$47                    {      inc     di                    }
      /$47                    {      inc     di                    }
      /$FE/$CD                {      dec     ch                    }
      /$75/$EE)               {      jnz     nxt                   }
  END;                        {DisplayChar}


  PROCEDURE TextString(OurString : Tstring);
  VAR
    i : Integer;
  BEGIN
    i := 1;
    FOR i := i TO Length(OurString) DO
      BEGIN
        DisplayChar(Byte(OurString[i]));
        xText := xText+1;
      END;
  END;                        {TextString}

  PROCEDURE EchoInput(Chr : Byte);
  BEGIN
    IF Chr = 8 THEN           { backspace }
      BEGIN
        IF xText > 12 THEN
          BEGIN
            DisplayChar($20);
            xText := xText-1;
            DisplayChar(Byte('_'));
          END
        ELSE
          xText := 12;
      END
    ELSE IF Chr = 10 THEN     { carriage return }
      BEGIN
        xText := 12;
      END
    ELSE IF Chr = 13 THEN     { line feed }
      xText := 12
    ELSE
      BEGIN
        DisplayChar(Chr);
        IF xText < 50 THEN
          BEGIN
            xText := xText+1;
            DisplayChar(Byte('_'));
          END
        ELSE
          BEGIN
            xText := 50;
            Sound(360);
            Delay(10);
            NoSound;
          END;
      END;
  END;                        {EchoInput}
