; RAMFONT.ASM 
;
; Loads the specified font file into the RamFont storage area of the
; InColor Card, and initializes the board for 4k RamFont operation with
; a 9x14 character matrix. This version updates the Mode Record.

; Hercules Computer Technology
; 2550 Ninth Street
; Berkeley, CA 94710

; February 1987

; RamFont equates

equipment	equ	11h

dmc_port	equ	03b8h		; Display mode control port
status_port	equ	03bah		; Display status port
index_reg	equ	03b4h		; 6845 index register
data_reg	equ	03b5h		; 6845 data register

scrn_on_nb	equ	08h
scrn_off_text  	equ	20h

rom_generator	equ	0		; xModeReg bit 0
ram_font	equ	1
nine_wide	equ	0		; xModeReg bit 1
eight_wide	equ	2	
fnt_4k		equ	0		; xModeReg bit 2
fnt_48k		equ	4

xModeReg	equ	14h		; character mode option port
scorereg	equ	15h		; register to set undersocre
strikereg	equ	16h		; register to set overstrike

RF_board_mask	equ	00110000b	; the GB222 will pass the GB112
RF_board_code 	equ	00010000b	; ID code test

blank_count	equ	2000

text_buf_seg	equ	0b000h
font_seg	equ	0b400h

open_num	equ	3dh		; DOS function numbers
disp_num	equ	9
close_num	equ	3eh
read_num	equ	3fh
terminate	equ	4Ch
dos_call	equ	21h

file_len	equ	4096		; length of one 256 character Type

col_seg		equ	40h		;DOS's record of number of columns
col_off		equ	4ah

cr		equ	0dh
lf		equ	0ah

entry_code	equ	0C0h

; The following structure is defined as a memory template for the assembler
; only, it is never declared, no memory is allocated.

record_struc	struc

ptr_to_next     dd	?		; 32-bit address of next record

ptr_to_reset	dd	?		; 32 -bit address of reset routine

manufacturer_id	db 18 dup (?)		; allows us to identify presence and
					; identity of record
version_id	db	?		; this is the first version

device_type	db	?		; 1 = HGC, 2 = CGA, 3 = EGA ...

record_length	dw	?		; for copying the record

rec_config_port db	?		; copy of Configuration Port (03BF)

rec_d_m_c_port	db	?		; copy of Display Mode Control (03B8)

rec_buffer_len	dw	?		; size of buffer

rec_blank_char  dw	?		; value for clearing screen

r_reserved	db	16 dup (0)	; for future use

r_0		db	?		; GB102, GB112, GB222
r_1		db	?		; GB102, GB112, GB222
r_2		db	?		; GB102, GB112, GB222
r_3		db	?		; GB102, GB112, GB222
r_4		db	?		; GB102, GB112, GB222
r_5		db	?		; GB102, GB112, GB222
r_rows_visible	db	?		; GB102, GB112, GB222
r_7		db	?		; GB102, GB112, GB222
r_8		db	?		; GB102, GB112, GB222
r_height_less_1	db	?		; GB102, GB112, GB222
r_cursor_start	db	?		; GB102, GB112, GB222
r_cursor_stop	db	?		; GB102, GB112, GB222
r_0ch		db	?		; GB102, GB112, GB222
r_0dh		db	?		; GB102, GB112, GB222
r_cursor_pos_hi	db	?		; GB102, GB112, GB222
r_cursor_pos_lo	db	?		; GB102, GB112, GB222
r_lp_trip_hi	db	?		; GB102, GB112, GB222
r_lp_trip_low	db	?		; GB102, GB112, GB222
r_12h		db	?		; unused
r_13h		db	?		; unused
r_xModeReg	db	?		; GB112, GB222
r_ScoreReg	db	?		; GB112, GB222
r_StrikeReg	db	?		; GB112, GB222
r_ExceptionReg	db	?		; GB222
r_PlaneMaskReg	db	?		; GB222
r_R_W_CtrlReg   db	?		; GB222
r_R_W_ColReg	db	?		; GB222
r_LatchProtect	db	?		; GB222
r_PaletteReg	db	?		; GB222
r_1dh		db	?		; unused
r_1eh		db	?		; unused
r_1fh		db	?		; unused

r_palette	db      ?		; These 16 bytes hold a copy of  
		db	?		; the GB222 palette.
		db	?
		db	?
		db	?
		db	?
		db	?
		db	?
		db	?
		db	?
		db	?
		db	?
		db	?
		db	?
		db	?
		db	?

r_type_usage	db	?		; six bytes provide a map of
		db	?		; 48 "Types". Each bit represents
		db	?		; a 4K block of character storage
		db	?		; RAM. For the GB112, only the first
		db	?		; 12 bits are meaningful.
		db	?

r_reserved_1	db	32 dup (0)	; for future use

r_end_record	db	3 dup (?)	; end of record

record_struc	ends

cseg	segment	para	public	'CODE'
	assume	cs:cseg,ds:cseg
	org 	80h
arg_count	db	0
arg_string	db	?
	org	100h
start:
	jmp	start1

handle		dw	?

filename	db	30 dup (?)

sign_on_msg	db	cr,lf,' RAMFONT.COM - Hercules Font Loading Utility v2.0',cr,lf
		db	' Copyright (C) 1987 Hercules Computer Technology, Inc.',cr,lf,'$'
	
open_err_msg	db	cr,lf,' Unable to open font file.',cr,lf,'$'

board_err_msg	db	cr,lf,' Hercules RamFont capable card '
		db	'not detected in system.',cr,lf,'$'

dos_version_msg db	cr,lf,' This program requires DOS 2.0 or higher.',cr,lf,'$'

record_addr	dd	?

mode_record_id	db	3,'HCT'

valid_record_id db	11,'HCT 1.GB222'

record_flag	db	0

start1:
	push	cs
	pop	ds

	call	get_dos_version		; make sure DOS is v2.0 or later
	jnz	dos_version_ok

	mov	ah,9
	lea	dx,dos_version_msg
	int	dos_call

	int	20h			; return for DOS verions < 2.0

dos_version_ok:

	call 	test_board		; see if we have a HGC model GB112
	jae	RamFont_ok		; or GB222

	mov	ah,disp_num
	lea	dx,sign_on_msg
	int	dos_call

	mov	ah,disp_num
	lea	dx,board_err_msg
	int	dos_call
	
	mov	ax,(terminate shl 8) or 1
	int	dos_call

RamFont_ok:
	call	look_for_record		; establish the presence of a
					; resident Mode Record

	push	cs			;copy arg_string into filename
	pop	es

	xor	cx,cx

	mov	cl,[arg_count]
	lea	si,arg_string
	lea	di,filename
rep	movsb
	mov	byte ptr cs:[di],0 		;for ASCIIZ string

;open font file
	mov	dx,offset filename+1
	mov	al,0
	mov	ah,open_num
	int	21h

	jnc	open_ok

	jmp	error_return

open_ok:
	mov	handle,ax

	mov	dx,03bfh		; set the card to HALF, making font
	mov	al,1			; storage area available.
	out	dx,al

	cmp	record_flag,1
	jne	s_r

	les	bx,record_addr		; tell the Mode Record about HALF
	mov	es:rec_config_port[bx],1

s_r:					; load font data
	mov	bx,handle
	mov	cx,file_len

	push	ds
	mov	ax,font_seg
	mov	ds,ax
	xor	dx,dx
	mov	ah,read_num
	int	21h
	pop	ds

close:
	mov	bx,handle
	mov	ah,close_num
	int	21h

;program the 6845 for a 9x14 dot character

	mov	bx,0720h			;blanking value
	call	prog_6845

;screen is still off, select the 4k ramfont
	mov	dx,index_reg
	mov	al,xModeReg
	out	dx,al

	mov	dx,data_reg
	xor	ax,ax
	mov	al,ram_font+nine_wide+fnt_4k
	out	dx,al

	cmp	record_flag,1
	jne	s_r_1

	les	bx,record_addr			; update xMode Reg in Record
	mov	es:r_xModeReg[bx],al

s_r_1:						; store correct column width
	mov	ax,col_seg			; for DOS
	mov	es,ax
	mov	di,col_off
	mov	al,80				;we want 80 columns
	mov	es:[di],ax
	push	cs
	pop	es

;turn the screen on, blink not activated

	mov	dx,dmc_port
	mov	al,scrn_on_nb
	out	dx,al

	cmp	record_flag,1
	jne	s_r_2

	les	bx,record_addr
	mov	es:rec_d_m_c_port[bx],al	; store dmc_port in Record

s_r_2:
	mov	ah,disp_num
	lea	dx,sign_on_msg
	int	dos_call

	mov	ax,(terminate shl 8) or 0	; and quit
	int	dos_call

;unable to open font file

error_return:
	mov	bx,720h
	call	prog_6845

	mov	dx,index_reg
	mov	al,xModeReg
	out	dx,al

	mov	dx,data_reg
	mov	al,rom_generator+nine_wide	;text mode
	out	dx,al

	cmp	record_flag,1
	jne	s_r_3

	les	bx,record_addr
	mov	es:r_xModeReg[bx],al

s_r_3:
	mov	ax,col_seg
	mov	es,ax
	mov	di,col_off
	mov	al,80				; we want 80 columns
	mov	es:[di],ax
	push	cs
	pop	es

	mov	dx,dmc_port			; turn on screen
	mov	al,scrn_on_nb
	out	dx,al

	cmp	record_flag,1
	jne	s_r_4

	les	bx,record_addr
	mov	es:rec_d_m_c_port[bx],al

s_r_4:
	mov	ah,disp_num
	lea	dx,sign_on_msg
	int	dos_call

	mov	ah,disp_num
	lea	dx,open_err_msg		; print error message
	int	dos_call

	mov	ax,(terminate shl 8) or 1
	int	dos_call

;***************************************************************************
; PROG_6845 - This procedure programs the 6845 for 9 x 14 matrix and
;	      updates the resident record.
;
; On ENTRY - BX contains the blanking value used to clear the text buffer
;****************************************************************************

r0_9dot		db	61h,50h,52h,0fh,19h,6,19h,19h,2,0dh,0bh,0ch,0,0

prog_6845	proc	near

	push	bx		; save blanking value

; get address of the 6845 data table

	lea	si,r0_9dot

;turn the screen off
screen_off:
	mov	al,scrn_off_text
	mov	dx,dmc_port
	out	dx,al

;program the 6845
	mov	dx,index_reg
	mov	cx,14

	xor	ah,ah			;start from register 0

	cld

loadtable:
	nop
	nop

	mov	al,ah
	out	dx,al			;output the register number

	inc	dx			;point to the data register
	lodsb				;load al with next table value

	out	dx,al			;output data value

	inc	ah			;point to next register
	dec	dx			;point to index register

	loop	loadtable		;continue loading until done

;clear the text buffer, but leave the screen off

setup_ptr:
	mov	ax,text_buf_seg
	mov	es,ax
	xor	di,di
	mov	cx,blank_count
	pop	ax			;get blanking value

;clear the buffer

rep	stosw

; update the record, if present
	cmp	record_flag,1
	jnz	no_record

	les	bx,record_addr
	mov	es:rec_blank_char[bx],ax
	mov	word ptr es:rec_buffer_len[bx],blank_count
	
	les	di,record_addr
	add	di,r_0
	lea	si,r0_9dot
	mov	cx,14
rep	movsb

no_record:

	ret

prog_6845	endp

;* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
; TEST_BOARD - Tests for the presence of a Hercules RamFont capable card
;
; RETURNS -  carry flag set if a GB112 or GB222 is not detected
;* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 

test_board	proc	near

	mov	ah,15			; check current video state
	int	10h

	cmp	al,7			; is it 80 x 25 "B&W" Card
	je	BIOS_mode_ok		; yes - continue

	jmp	test_failed		; no - quit

BIOS_mode_ok:		       	
	mov	dx,status_port		; record state 
	in	al,dx			
	and	al,80h			; save bit 7 for test
	mov	ah,al

	mov	cx,8000h
examine:
	in	al,dx			; take another reading
	and	al,80h			; again, save bit seven
	cmp	al,ah
	jne	hgc_ok			; if bit 7 changes, then it
	loop	examine			; is a Hercules Card
    
	jmp	test_failed		; after this long it must be
					; something else - quit.
        
hgc_ok:
	in	al,dx			; test for RamFont capability
	and	al,RF_board_mask    	; clear all but bits 4, 5

	cmp	al,RF_board_code	; test ID bits
	jne	test_failed		; exit, not a GB112 or GB222

	clc				; clear carry flag
	ret				; normal return

test_failed:
	stc				; set the carry flag
	ret				; error return

test_board	endp

;* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
; GET_DOS_VERSION - returns ZF set if DOS version < 2.0
;* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
get_dos_version	proc	near
	mov	ah,30h
	int	dos_call
	cmp	al,2
	jb	not_correct_version

	xor	ax,ax
	inc	ax			; Artificially clear (ZF)

	ret

not_correct_version:
	xor	ax,ax			; Artificially set (ZF)
	ret

get_dos_version	endp

;* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
; LOOK_FOR_RECORD - This procedure checks for the presence of a
;		    resident Mode Record.
; ON ENTRY - Assumes that the RECORD structure is defined.
; RETURNS - record_flag = 1 if a proper record is found.
;	    record_addr contains the 32 bit address of the proper Record.
;* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
look_for_record	proc	near

	push	es

	mov	ah,entry_code
	sahf
	int	11h

check_id:
	mov	word ptr record_addr,ax
	mov	word ptr record_addr+2,dx

	les	di,record_addr
	add	di,manufacturer_id

	xor	cx,cx

	lea	si,mode_record_id		; is a Mode Record installed
	mov	cl,byte ptr [si]
	inc	si

	cld
repz	cmpsb

	jcxz	mode_record_present		; yes there is a resident
						; record, see if it's ours

	mov	record_flag,0			; no record present, return
	pop	es
	ret

mode_record_present:

	les	di,record_addr
	add	di,manufacturer_id

	xor	cx,cx

	lea	si,valid_record_id
	mov	cl,byte ptr [si]
	inc	si

	cld
repz	cmpsb

	jcxz	valid_record

; if not our record, is there a pointer to another installed record ?

        les	di,record_addr 		; look at the ptr_to_next
					; field in the present record
	cmp	word ptr es:[di],0 	; if this field is 0 then no
	jne	keep_checking		; further records exist
	
	pop	es
	ret

keep_checking:

	mov	ax,es:[di]		; if field contains a pointer to
	mov	dx,es:[di+2]		; another record - use that address
					; to keep checking
	jmp	check_id

valid_record:
	mov	record_flag,1

	pop	es
	ret

look_for_record	endp

cseg	ends
	end	start
