rem *******************************************************
rem Ship level LANSpool installation batch file
rem
rem NOTE: THIS CURRENTLY ONLY SUPPORTS ICLAS 1.41
rem
rem This batch file will install LANSpool 3.50C and replace
rem ICLAS modules necessary to operate ship level LANSpool with
rem ICLAS.
rem
rem Author Mark Gehring 05-31-93
rem *******************************************************

@echo off
  set N=NUL
  if exist z:\public\clsprmpt.exe goto SKIP_PRMPT
  copy %DRV%%SRC%\14progs\clsprmpt.exe z:\public >%n%

:SKIP_PRMPT
  rem ***** Check for the existence of these updates already on server ***********
  if not exist z:\public\patchver\LNSP35C1.VER goto not_here
  %DRV%\root\color
  z:\$homer$\clsprmpt %DRV%%SRC%\reinst.msg
  clsyn
  if errorlevel 1 goto END
  echo Y
  goto DO_IT

:NOT_HERE
  %DRV%\root\color
  z:\$homer$\clsprmpt %DRV%%SRC%\inst.msg
  clsyn
  if errorlevel 1 goto END
  echo Y

:DO_IT
  z:\$homer$\clsprmpt con "Preparing to install the LANSpool update" " " "Please wait. . ."
  z:
rem ************************************************************************
rem ** Installing new LANSpool and removing old LANSpool files if they exist
rem ************************************************************************
  if exist z:\public\clsmkdir.exe goto MK_DIR
  copy %DRV%%SRC%\14progs\clsmkdir.exe z:\public  >%n%
  flag z:\public\clsmkdir.exe sro >%n%
:MK_DIR
  z:\public\clsmkdir z:\login\lanspool >%n%
  z:\public\clsmkdir z:\public\patchver >%n%
  copy %DRV%%SRC%\LNSP35C1.ver z:\public\patchver >%n%
  map L:=SYS:\LOGIN\LANSPOOL <z:\public\clsyes >%n%

  z:\$homer$\clsprmpt con "Removing old LANSpool files" " " "Please wait. . ."
  echo C | flag L:*.* srw <%DRV%\root\patchC >%n%
  if exist L:par*.*     del L:par*.*     >%n%
  if exist L:serial??.* del L:serial??.* >%n%
  if exist L:serial?.*  del L:serial?.*  >%n%
  if exist L:rstatus.*  del L:rstatus.*  >%n%
  if exist L:status.*   del L:status.*   >%n%
  if exist L:setname.*  del L:setname.*  >%n%
  if exist L:node$hlp.* del L:node$hlp.* >%n%
  if exist L:lsdelete.* del L:lsdelete.* >%n%
  if exist L:rem_node.* del L:rem_node.* >%n%
  if exist L:lan$msg.*  del L:lan$msg.*  >%n%
  if exist L:lan$help.* del L:lan$help.* >%n%
  if exist L:lan$err.*  del L:lan$err.*  >%n%
  if exist L:cli$hlp.*  del L:cli$hlp.*  >%n%
  if exist L:node.*     del L:node.*     >%n%

  if not exist L:lanspool.ini goto NO_INI
  if exist L:\login\lanspool\clsupdls.exe flag L:\login\lanspool\clsupdls.exe srw >%n%
  L:
  cd L:\login\lanspool >nul
  z:\$homer$\clsprmpt con "Converting LANSPOOL.INI file into" "new .INI format." " " "Please wait. . ."
  copy %DRV%%SRC%\14progs\clsupdls.exe L:  >%N%
  ctty %n%
  L:clsupdls >%n%
  ctty con
  if exist L:clsupdls.exe del L:clsupdls.exe >%n%
:NO_INI
  z:\$homer$\clsprmpt con "Unpacking LANSpool files." " " "Please wait. . ."
  %DRV%%SRC%\350C\350C *.*  L:\login\lanspool -o  >%n%
  path %path%;L:.

  z:\$homer$\clsprmpt %DRV%%SRC%\lanspool.msg
  pause >nul

  L:setup INITIAL
  if exist z:\public\lsqueues.exe flag z:\public\lsqueues.exe srw >%n%
  copy %DRV%%SRC%\14progs\lsqueues.exe z:\public  >%n%
  z:\public\lsqueues >%n%
  del z:\public\lsqueues.exe >%n%
  del L:setup.exe >%n%
  if exist L:\login\lanspool\lanspool.vap del L:\login\lanspool\lanspool.vap >%n%
  if exist L:\login\lanspool\lanspool.nlm del L:\login\lanspool\lanspool.nlm >%n%

  echo C | flag L:\login\lanspool\*.* sro <%DRV%\root\patchC >%n%

  z:
  cd \public
  z:\$homer$\clsprmpt con "Making the TEACHERS user group" "print queue operators."
  z:\public\clstpcon
  if errorlevel 1 z:\$homer$\clsprmpt con "Can't add Teachers as print queue operators." "Teachers can't delete students' print jobs."

  z:\$homer$\clsprmpt con "Updating IBM Classroom LAN Administration System files." "Please wait. . ."
  flag z:\login\lanspool\clsprtst.exe srw >%n%
  flag z:\public\clslansp.exe         srw >%n%
  flag z:\admin\clsstaid.exe          srw >%n%
  copy %DRV%%SRC%\14progs\clsprtst.exe z:\login\lanspool >%n%
  copy %DRV%%SRC%\14progs\clslansp.exe z:\public  >%n%
  copy %DRV%%SRC%\14progs\clsstaid.exe z:\admin   >%n%
  flag z:\login\lanspool\clsprtst.exe sro >%n%
  flag z:\public\clslansp.exe         sro >%n%
  flag z:\admin\clsstaid.exe          sro >%n%
  z:\$homer$\clsprmpt con "The LANSpool update has been completed."


:CLEANUP
  if exist L:\login\lanspool\$*.* flag L:\login\lanspool\$*.* srw <%DRV%\root\patchY >nul
  if exist L:\login\lanspool\$*.* del L:\login\lanspool\$*.* >nul
  if exist z:\public\purge.exe z:\public\purge z:\login\lanspool /A >nul
  map del L: <z:\public\clsyes >%n%

:FIXLOG
rem  Ŀ
rem   Update the FIX.LOG in Z:\PUBLIC on the server                    
rem   LOG.EXE will take a given file (FIX.TXT) as its first argument   
rem   and APPENDS it to another given file (FIX.LOG) as its second     
rem   argument with the system DATE & TIME and a the application name  
rem   which the third argument (optional).                             
rem  

z:\$homer$\clsprmpt con "Please wait while updating the Fix Log"
if exist z:\$homer$\fix.txt del z:\$homer$\fix.txt >nul
if exist %DRV%%SRC%\fix.txt copy %DRV%%SRC%\fix.txt z:\$homer$ >nul
z:
z:\$homer$\log z:\$homer$\fix.txt z:\public\fix.log LANSpool V350C
if exist z:\public\purge.exe z:\public\purge z:\public\fix.log >nul
%DRV%

:END
