:
:    BACKALL.BAT -- Generates a parameter file and invokes PS2TAPE to 
:	back up all files the drives specified, for example:
:
:		"BACKALL C D E"
:	
:	Will back up all files on drives C, D, and E.  
:
:	If no drives are specified, BACKALL will invoke PS2TAPE to
:	back up all files on the currently logged drive.
:
@ECHO OFF

:-----Delete previous parameter file
IF EXIST BACKALL.BPF DEL BACKALL.BPF 

:-----Check for command line arguments
IF "%1"=="" GOTO ELSE

    :-----Add line to parameter file for each listed drive
    :BEGINWHILE
        IF "%1"=="" GOTO ENDWHILE
        ECHO /x IMAGE-%1 /n IMAGE-%1 /r /q /s %1:\*.* >>BACKALL.BPF
        SHIFT
        GOTO BEGINWHILE
    :ENDWHILE

    GOTO ENDIF

:ELSE
    :------Backup currently logged file only
    ECHO /n IMAGE /x IMAGE /r /q /s \*.* >>BACKALL.BPF

:ENDIF

:-----Start backup
PS2TAPE BACKUP /f BACKALL.BPF
DEL BACKALL.BPF
