@echo off
rem
rem
rem             Written by   : Patch Development Team.
rem             Last modified: 06/02/1993.
rem
rem             DST  is the path where software is installed on server.
rem             SRC  is the path where software is on CDROM.
rem             DRV  is the drive of the CDROM.
rem             INS  is being set to "T" if system was configured once
rem             PAR  is being set to user selection
rem                  either ALL or SEL
rem             PRS  is being SET to previous (SRC) path
rem              NO  is being defaulted to "Y".  It will be SET
rem                  to "N" if user selects "N" in the patch developer
rem                  FIX BAT
rem

rem **  Just in case the mappings of drive Z: is not set to PUBLIC **
cd z:\public >nul

:BEGINMAIN
rem  **  Display Main Menu to the screen  **
%DRV%\root\mainmenu
if errorlevel 4 goto FIXLOG
if errorlevel 3 goto SELCT
if errorlevel 2 goto DOALL
if errorlevel 1 goto READALL
if errorlevel 0 goto EXITODOS

:EXITODOS
goto END

:READALL
z:\$homer$\readme z:\$homer$\readme.txt
goto BEGINMAIN

:DOALL
rem **  User Selects Install All  **
SET PAR=A
goto CONFSYS

:SELCT
rem **  User selects Install Selective Software  **
SET PAR=S
goto CONFSYS

:FIXLOG
rem **  View Fix Log  **
if exist z:\public\fix.log  z:\$homer$\readme z:\public\fix.log
if not exist z:\public\fix.log  z:\$homer$\readme %DRV%\ROOT\fix.log
goto BEGINMAIN

rem   Ŀ
rem    Determine the system configuration.                      
rem    If INS is not SET to " " check for the following:        
rem            1. Check for diskspace needed to do the install. 
rem            2. Copy utilities to the $HOMER$ on the server.  
rem            3. Determine Software installed on server.       
rem            4. Apply the updates to the server.              
rem                                                             
rem    If INS is being SET to "T" Apply updates to the server.  
rem   

:CONFSYS
if @%INS%==@T goto CHKFOUND

:COPYFILES
%DRV%\root\wait
rem **  is there enough diskspace?  **
%DRV%\utils\gfs z:  300 >nul
if errorlevel 1 goto INSUFDSK

rem **  Copying utilities   **
 ctty nul
  copy %DRV%\utils\*.* z:\$homer$ >nul
 ctty con

:CHKFOUND
rem **  Determine user selection is it   **
rem **  Install All ?                    **
rem **  Install Selective Software ?     **
if @%PAR%==@A goto DOALLx
if @%PAR%==@S goto SELCTx

rem  Ŀ
rem    If the user Selects "INSTALL ALL" the following will be done      
rem       1. FINDSOFT.EXE is used to determine the software on the server
rem          and write the system configuration to "FOUND.LOG" and store 
rem          it in Z:\$homer$ on the server for ALL.EXE to use.          
rem       2. SIZE0.EXE checks if found.log size is 0.                    
rem          if it is, no update is needed, return to Main Menu.         
rem       3. All.EXE takes "FOUND.LOG" as an input and it writes         
rem          the SRC and DST paths to the file named "SETDIR.BAT" and    
rem          stores it in Z:\$HOMER$ on the server.                      
rem       4. CALL Z:\$homer$\SETDIR.BAT to set the SRC and DST paths     
rem          in the e_environment.                                       
rem                                                                      
rem             Environment Variables used in this label.                
rem                                                                      
rem           PAR: will be freed since it is not needed any more         
rem           PRS: must not have any values                              
rem           INS: will be set to "T" so there will be no need           
rem                to configure server again.                            
rem            NO: Defaults to "Y". will be SET to "N" only              
rem                by patch developers if the user selects "N"           
rem                to not reapply the patch.                             
rem  

:DOALLx

for %%v in (DST PAR PRS) do SET %%v=
SET INS=T
SET  NO=Y

if exist z:\$homer$\found.log goto SKIPMSG
%DRV%\root\longwait
if errorlevel 1 goto BEGINMAIN

:SKIPMSG
if not exist z:\$homer$\found.log z:\$homer$\findsoft z:\$homer$\update.log z:\$homer$ /Q
if errorlevel 1 if not errorlevel 2 goto USRABORT
z:\$homer$\size0 z:\$homer$\found.log
if errorlevel 1 goto BEGINMAIN
z:\$homer$\all z:\$homer$\found.log z:\$homer$
if errorlevel 0 if not errorlevel 1 goto LOOPALL
goto BEGINMAIN

rem ** User decided to abort.  Remove the found.log if it existed **
:USRABORT
if exist z:\$homer$\found.log del z:\$homer$\found.log >nul
goto BEGINMAIN

:LOOPALL
rem ** SRC=BLANK.  SO don't do the last software twice  **
SET SRC=
rem   Ŀ
rem    1. If previous source path(PRS)=new source path(SRC)  SET FIN to "T"  
rem       which will be used by patch developers to test for the existance   
rem       of the file version on the server.                                 
rem                                                                          
rem    2. If previous source path(PRS)=new source path(SRC) and              
rem       user selection in the patch developer FIX BAT is "N"               
rem       then do not attempt to update the software.                        
rem   

call z:\$homer$\setdir.bat
rem  **  The patch version is already installed  so  **
rem  **  do not check for it again.                  **

if @%SRC%==@%PRS% SET FIN=T
if @%SRC%==@%PRS% if @%NO%==@N goto SKIPINST
if @%SRC%==@%BLANK% goto SKIPINST
call %DRV%%SRC%\g.bat

:SKIPINST
rem   Ŀ
rem    1. SET (PRS) to the previous source path (SRC) 
rem    2. Clear (FIN)                                 
rem    3. REMOVE.EXE will remove the  last (DST) and  
rem       the (SRC) lines from the file SETDIR.BAT    
rem   
SET PRS=%SRC%
SET FIN=
z:\$homer$\remove z:\$homer$\setdir.bat
if errorlevel 0 if not errorlevel 1 goto LOOPALL
goto BEGINMAIN


rem   Ŀ
rem    If the user Selects "INSTALL ALL" the following will be done          
rem       1. SELECT.EXE displays UPDATE.LOG, accepts user selection,searches 
rem          for the selected software, and writes the (SRC) and (DST) paths 
rem          to the file named "SETDIR.BAT" and stores it in Z:\$HOMER$ on   
rem          the server.                                                     
rem       3. CALL Z:\$homer$\SETDIR.BAT to set the (SRC) and (DST) paths     
rem          in the e_environment.                                           
rem                                                                          
rem             Envrionment Variables used in this label.                    
rem                                                                          
rem           PAR: will be freed since it is not needed any more             
rem           PRS: must not have any values                                  
rem           INS: will be sets "T" so there will be no need                 
rem                to configure server again.                                
rem            NO: Defaults to "Y". will be SET to "N" only                  
rem                by patch developers if the user selects "N"               
rem                to not reapply the patch.                                 
rem   

:SELCTx
for %%v in (DST PAR PRS) do SET %%v=
SET NO=Y
SET INS=T

:DISPLAY
z:\$homer$\select z:\$homer$\update.log z:\$homer$
if errorlevel 2 if not errorlevel 3 goto LOOPBAT
if errorlevel 1 if not errorlevel 2 goto DISPLAY
if errorlevel 0 if not errorlevel 1 goto BEGINMAIN

:LOOPBAT
SET SRC=

rem    Ŀ
rem     1. If previous source path(PRS)=new source path(SRC)  SET FIN 
rem        to "T" which will be used by patch developers to test for  
rem        the existance of the file version on the server.           
rem     2. If user selection in the patch developer FIX BAT is "N"    
rem        then do not attempt to update the software.                
rem     3. SET (PRS) to the previous source path (SRC)                
rem     4. Clear (FIN)                                                
rem     5. REMOVE.EXE will remove the  last (DST) and                 
rem        the (SRC) lines from the file SETDIR.BAT                   
rem    
call z:\$homer$\setdir.bat
if @%SRC%==@%PRS% SET FIN=T
if @%SRC%==@%PRS% if @%NO%==@N goto NOINST
if @%SRC%==@%BLANK% goto NOINST
call %DRV%%SRC%\g.bat

:NOINST
SET PRS=%SRC%
SET FIN=
z:\$homer$\remove z:\$homer$\setdir.bat
if errorlevel 0 if not errorlevel 1 goto LOOPBAT
goto DISPLAY

:INSUFDSK
%DRV%\root\color
Echo.
Echo.
Echo.
Echo.
Echo.
Echo.
Echo.
Echo.
Echo                  ͻ
Echo                                                     
Echo                     It has been determinded that    
Echo                     there is insufficient disk      
Echo                     disk space to aplly patches.    
Echo                     Please ensure that there is     
Echo                     enough disk space on the SYS    
Echo                     volume before applying any      
Echo                     of the patches.                 
Echo                                                     
Echo                  ͼ
Echo.
Echo                   Press any key to continue...
pause >nul
goto BEGINMAIN

:END
