/* --------------------------------- altitude.c ----------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* paint the Head Up Display: altitude
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

#include "fly.h"
#include "hud.h"

#undef CP
#undef CW
#undef CS

#define CP	view->viewport
#define CW	view->window
#define CS	view->screen

extern void FAR
show_altitude (VIEW *view, OBJECT *p, int sx, int sy, int maxx, int maxy,
	int orgx, int orgy, int ttx, int tty, int tx, int ty, int ss)
{
	int	hud, hud1, big, fine, xfine, fa18, f16, f15, fcl, knots, blink;
	int	x, y, base, s, x0, y0, dm, dd, i, ex;
	int	res, unit, vtick;
	int	scale_ref, scale_len;
	long	t;

	hud = EE(p)->hud;
	hud1 = EE(p)->hud1;
	fine = hud & HUD_FINE;
	xfine = hud & HUD_XFINE;
	big = hud & HUD_BIG;
	i = hud1 & HUD_TYPES;
	fa18 = i == HUD_FA18;
	f16  = i == HUD_F16;
	f15  = i == HUD_F15;
	fcl  = i == HUD_CLASSIC;
	knots = hud1 & HUD_KNOTS;
	blink = ((int)st.present)&0x0080;

	if (sx < 100) {
		if (xfine)
			fine = 1;
		xfine = 0;
	}

	dd = num_size (9L, ss);

	if (fa18) {
		if (!(EE(p)->hud2 & HUD_ALTITUDE))
			return;

		s = (ss*7+3)/6;				/* the large font */
		x0 = num_size (9L, s);
		y0 = 3*dd + 2*x0 + 1;
		x = sx-tx;
		y = fmul (sx, F18ALT) + y0;
		if (x > y)
			x = y;
		x += orgx;
		add_line (x,     orgy,     T_MOVE);	/* outline */
		add_line (x,     orgy+s+1, st.hfg);
		add_line (x-y0,  orgy+s+1, st.hfg);
		add_line (x-y0,  orgy,     st.hfg);
		add_line (x,     orgy,     st.hfg);

		y = orgy + s;
		t = p->R[Z]/VONE;			/* altitude */
		if (knots)
			t = 3*t + fmul ((int)t, 4601);	/* feet */
		i = (int)(labs (t) % 1000);
		t /= 1000;
		if (t == 0) {
			dm = num_size ((long)i, s);
			stroke_num (x-dm, y, (long)i, s, st.hfg);
		} else {
			x0 = x - 3*dd;
			dm = num_size (t, s);
			stroke_num (x0-dm, y, t, s, st.hfg);
			y -= (s-ss)/2;		/* center the digits */
			stroke_frac (x0, y, (long)i, 3, 0, ss, st.hfg);
		}

		y = orgy - ss/2;
		t = p->V[Z]*60L/VONE;			/* vertical speed */
		if (knots)
			t = 3*t + fmul ((int)t, 4601);	/* feet */
		t = t/10*10;				/* round to 10s */
		dm = num_size (t, ss);
		stroke_num (x-dm, y, t, ss, st.hfg);
	} else {
	    long	h;
	    int		frac;

	    scale_ref = f16 ? 16 : (f15 ? 15 : 30);
	    scale_len = f16 ?  8 : (f15 ?  8 : EE(p)->tapelen);

	    h = p->R[Z]/VONE;
	    if (knots)
		h = 3*h + fmul ((int)h, 4601);	/* feet */
	    if (f15) {
		if (labs(h) <= 1000L) {
			res = 20;
			unit = 20;
			vtick = VONE*5;
		} else {
			res = 100;
			unit = 100;
			vtick = VONE*100;
		}
		frac = 0;
	    } else if (labs(h) <= 1000L) {
		res = 10;
		unit = f16 ? 10 : 100;
		vtick = VONE*10;
		frac = 0;
	    } else {
		res = 100;
		unit = 1;
		vtick = VONE*100;
		frac = 1;
	    }

	    if (h >= 0) {
		x0 = (int)(h % (100L*res));
		ex = (int)(h/(100L*res));
	    } else {
		x0 = 100*res-(int)((-h) % (100L*res));
		ex = -(int)(-h/(100L*res) + 1);
	    }
	    s = x0/res;
	    y0 = x0 - s*res;
	    y0 = orgy + muldiv (y0, sy, scale_ref*res);
	    dm = 2+tx;
	    base = orgx;
	    if (f15)
	    	base += fmul (sx, F15ALT);
	    else if (f16)
	    	base += fmul (sx, F16ALT);
	    else
		base += sx;
/*
 * aoa at top of scale
*/
	    if (f16||f15) {
	    	t = ANG2DEG00(EE(p)->misc[7])/10;
	    	x = num_size (t, ss) + dd/2;
	    	if (t < 10 && t > -10)
	    		x += dd;			/* leading zero */
	    	y = muldiv (sy, scale_len, scale_ref);
		stroke_frac (base-x, orgy-y, t, 0, 1, ss, st.hfg);
	    }

	    if (!(EE(p)->hud2 & HUD_ALTITUDE))
		return;

	    if (f15) {
		y = muldiv (scale_len, sy, scale_ref);
		add_line (base, orgy - y, T_MOVE);
		add_line (base, orgy + y, st.hfg);
	    }
	    for (i = 1-scale_len, s += i; i <= scale_len; ++i, ++s) {
		y = y0 - muldiv (i, sy, scale_ref);
		if (f16||f15) {
			if (0 == s%5) {
				t = (ex*100L + s)*unit;
				if (big)
					dm = -num_size (t, ss)-tx;
				stroke_frac (base+dm, y+ss/2, t, 0, frac, ss,
						st.hfg);
			}
			add_line (base, y, T_MOVE);
			add_line (base+1*ttx, y, st.hfg);
		} else if (0 == s%10) {
			add_line (base, y, T_MOVE);
			add_line (base+3*ttx, y, st.hfg);
			if (xfine || (i >= -11 && i <= 11)) {
				t = (ex*10 + s/10)*unit;
				if (big)
					dm = -num_size (t, ss)-tx;
				stroke_num (base+dm, y-2, t,
					ss, st.hfg);
			}
		} else if (fine) {
			if (0 == s%2) {
				add_line (base, y, T_MOVE);
				add_line (base+1*ttx, y, st.hfg);
			}
		} else if (0 == s%5) {
			add_line (base, y, T_MOVE);
			add_line (base+2*ttx, y, st.hfg);
		} else if (xfine) {
			add_line (base, y, T_MOVE);
			add_line (base+1*ttx, y, st.hfg);
		}
	    }
	    if (big)
		base -= 3*tx;
	    if (f15) {
		    add_line (base-2*tx, orgy-ty, T_MOVE); /* reading mark */
		    add_line (base,      orgy,    st.hfg);
		    add_line (base-2*tx, orgy+ty, st.hfg);
	    } else {
		    add_line (base,      orgy, T_MOVE);	/* reading mark */
		    add_line (base-3*tx, orgy, st.hfg);
	    }
	    if (fcl) {
/*
 * show vertical velocity beside the scale
*/
		unit = vtick*5;			/* full scale range */
		s = p->V[Z];			/* vz */
		if (knots)
			s = 3*s + fmul (s, 4601);	/* feet */
		if (s > unit)
			s = unit;
		if (s < -unit)
			s = -unit;
		s = muldiv (sy, s, unit+vtick);
		add_line (base-tx, orgy,   T_MOVE);
		add_line (base-tx, orgy-s, st.hfg);

		y0 = muldiv (sy, vtick, unit+vtick);
		if (s > 0) {
			for (y = 0; y <= s; y += y0) {
				add_line (base-tx, orgy-y, T_MOVE);
				add_line (base,    orgy-y, st.hfg);
			}
		} else if (s < 0) {
			for (y = 0; y >= s; y -= y0) {
				add_line (base-tx, orgy-y, T_MOVE);
				add_line (base,    orgy-y, st.hfg);
			}
		}
	    }
	}
}
