/* --------------------------------- cockpit.c ------------------------------ */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Render instruments etc.
*/

#include <stdio.h>
#include <stdlib.h>

#include "fly.h"

#undef CP
#undef CW
#undef CS

#define CP      view->viewport
#define CW      view->window
#define CS      view->screen

#define	ifg	st.hudlow	/* instruments color */
#define	mfg	st.hudhigh	/* instruments marker color */

extern void FAR
show_inst (VIEW *view, OBJECT *obj)
{
	int	orgx, orgy, sizex, sizey, sizexx, tx, ty, v, x, y;
	int	spitch, croll, sroll, sdir, cdir;

	if (!obj || ET_PLANE != obj->e_type ||
	    !(EE(obj)->flags & PF_INSTRUMENTS))
		return;

	orgx  = fmul (CW->orgx, CS->sizex) + CS->minx;	/* show orientation */
	orgy  = fmul (CW->orgy, CS->sizey) + CS->miny;
	sizex = fmul (CW->maxx, CS->sizex);
	sizey = fmul (CW->maxy, CS->sizey);
	orgx = orgx + sizex;
	orgy = orgy + sizey;
	sizex /= 8;
	sizey /= 4;
	orgx -= sizex;
	orgy -= sizey;
	tx = sizex/8;
	ty = sizey/8;

	add_line (orgx + sizex, orgy + sizey, T_MOVE);	/* outline */
	add_line (orgx + sizex, orgy - sizey, ifg);
	add_line (orgx - sizex, orgy - sizey, ifg);
	add_line (orgx - sizex, orgy + sizey, ifg);
	add_line (orgx + sizex, orgy + sizey, ifg);

	sizexx = sizex - tx;
	add_line (orgx - sizex,  orgy, T_MOVE);		/* ticks */
	add_line (orgx - sizexx, orgy, ifg);
	add_line (orgx + sizex,  orgy, T_MOVE);
	add_line (orgx + sizexx, orgy, ifg);

	v = muldiv (EE(obj)->rudder, sizex, 90);	/* rudder */
	add_line (orgx + v, orgy + sizey, T_MOVE);
	add_line (orgx + v, orgy + sizey - ty, mfg);

	v = muldiv (EE(obj)->throttle, sizey, 100);	/* throttle */
	add_line (orgx + sizex,  orgy - v, T_MOVE);
	add_line (orgx + sizexx, orgy - v, mfg);

#define	VLIMIT	VONE*300
	v = obj->V[Z];					/* vz */
	if (v > VLIMIT)
		v = VLIMIT;
	if (v < -VLIMIT)
		v = -VLIMIT;
	v = muldiv (v, sizey, VLIMIT);
#undef	VLIMIT

	x = orgx - sizex;
	y = orgy - v;
	add_line (x - tx, y - ty, T_MOVE);
	add_line (x + tx, y + ty, mfg);
	add_line (x - tx, y + ty, T_MOVE);
	add_line (x + tx, y - ty, mfg);

	sroll  = SIN(obj->a[Y]);			/* plane */
	sroll  = muldiv (sroll,  sizey/2, FONE);
	croll  = COS(obj->a[Y]);
	croll  = muldiv (croll,  sizexx,  FONE);
#if 0
	spitch = SIN(obj->a[X]);
#else
	spitch = obj->a[X];
#endif
	spitch = muldiv (spitch, sizey/2, FONE);
	orgy  -= spitch;

	add_line (orgx - croll,   orgy - sroll,   T_MOVE);
	add_line (orgx + croll,   orgy + sroll,   ifg);

	croll  = muldiv (croll,  sizey/2, sizexx);
	sroll  = muldiv (sroll,  sizexx,  sizey/2);

	add_line (orgx,           orgy,           T_MOVE);
	add_line (orgx + sroll/4, orgy - croll/4, ifg);
	orgy += spitch;
	orgx -= 2*sizex;
/*
 * direction
*/
	x = sizex;
	y = sizey/2;

	orgy += y;

	sdir  = SIN(obj->a[Z]);
	sdir  = muldiv (sdir,  sizexx, FONE);
	cdir  = COS(obj->a[Z]);
	cdir  = muldiv (cdir,  y,  FONE);

	add_line (orgx + x, orgy + y, T_MOVE);		/* outline */
	add_line (orgx - x, orgy + y, ifg);
	add_line (orgx - x, orgy - y, ifg);
	add_line (orgx + x, orgy - y, ifg);

	add_line (orgx, orgy, T_MOVE);
	add_line (orgx - sdir, orgy - cdir, ifg);	/* hand */
	orgx -= 2*sizex;
/*
 * speed
*/

#define	MAXSPEED	(VONE*600)
	x = obj->speed;
	if (x > MAXSPEED)
		x = MAXSPEED;
	else if (x < 0)
		x = 0;
	x = muldiv (x, 2*sizex, MAXSPEED);
	y = sizey/2;
	add_line (orgx + sizex, orgy - y, T_MOVE);		/* scale */
	add_line (orgx - sizex, orgy - y, ifg);
	add_line (orgx,             orgy + y, T_MOVE);	/* hand */
	add_line (orgx - sizex + x, orgy - y, ifg);
}
