/* --------------------------------- gettimer.c ----------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Read and print the status of the PC timer 0. It should be in mode 3.
*/

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>

#define	CHANNEL_0	0x40
#define	CHANNEL_1	0x41
#define	CHANNEL_2	0x42
#define	COMMAND_REG	0x43

static short far
disable (void)
{
	short	flags;

	_asm {
		pushf
		pop	flags
		cli
	}
	return (flags);
}

static void far
enable (short flags)
{
	_asm {
		push	flags
		popf
	}
}

int
main ()
{
	int	status;
	short	flags;

	flags = disable ();
	outp (COMMAND_REG, 0xc2);	/* read back timer 0 */
	status = inp (CHANNEL_0);
	(void)inp (CHANNEL_0);
	(void)inp (CHANNEL_0);
	enable (flags);

	printf ("Timer 0 status is %x\n", status);

	exit (0);
	return (0);
}
