/* --------------------------------- timer.c -------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Time services for Microsoft WINDOWS. Resolution in milliseconds.
*/

#include <stdio.h>
#include <time.h>

/* set this for Windows 3.1 multimedia time GetTime */
#define MMSYSTEM 1

#include <windows.h>
#if MMSYSTEM
#include <mmsystem.h>
#endif

#include "config.h"
#include "fly.h"
#include "tick.h"

static Ulong FAR
timer_milli (void)
{
#if MMSYSTEM
	return (timeGetTime ());
#else
	return (GetTickCount ());
#endif
}

static int FAR
timer_hires (void)		/* get fastest timer available */
{
	static int last = 0;

	return (++last);	/* how fast do you want it? */
}

static int FAR
timer_init (void)
{
	return (0);
}

static void FAR
timer_term (void)
{
	return;
}

static char * FAR
timer_ctime (void)
{
	time_t	tm;
	char	*t;
	int	bug;

	tm = time (0);
	t = ctime (&tm);
	bug = strlen (t);	/* micro&soft hits again! */
	t[bug - 1] = '\0';	/* kill NewLine */

	return (t);
}

struct TmDriver TmDriver = {
#if MMSYSTEM
	"timeGetTime",
#else	
	"GetTickCount",
#endif	
	0,
	timer_init,
	timer_term,
	timer_milli,
	timer_hires,
	timer_ctime
};
