/* --------------------------------- oclassic.c ----------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Dynamics of the Classic.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "fly.h"
#include "plane.h"

extern void FAR
dynamics_classic (OBJECT *p, int interval)
{
	POINTER	*ptr;
	int	t;
	VECT	OLDV, A;
	AVECT da;

	if (dynamics_input (p, interval))
		return;

	ptr = p->pointer;

#define	ADELTA	(VD90/45*EP->opt[3])
	p->da[Y] = -muldiv (2*EX->ailerons, ADELTA*10, 100);
	p->da[X] = muldiv (EX->elevators, ADELTA*10/2, 100);
#undef ADELTA

	if (100 == EX->throttle) {
		t = EP->ab_thrust - EP->mil_thrust;
		t = EP->mil_thrust + muldiv (EX->afterburner, t, 100);
	} else {
		t = muldiv (EX->throttle, EP->mil_thrust, 100);
		if (t < 0)
			t /= 2;		/* reverse thrust is 50% efficient */
	}

	dampen (&EX->thrust, t, 8);

	t = (EX->afterburner) ? EP->ab_sfc : EP->mil_sfc;
	t = muldiv (iabs(EX->thrust), t, 60*60/10);
	EX->misc[12] = t;
	if ((EX->fuel -= TADJ (t)) < 0) {
		EX->fuel = 0;
		EX->thrust = 0;
	}

	dampen (&p->speed, EX->thrust/4*10, 16);

	p->da[Z] = muldiv (p->speed, EX->rudder, 100)/VONE;

	da[X] = TADJ (p->da[X]) * VONE;
	da[Y] = TADJ (p->da[Y]) * VONE;
	da[Z] = TADJ (p->da[Z]) * VONE;
	Myxz (p->T, da);

	Mroty (p->T, p->a[Y]);
	Mrotx (p->T, p->a[X]);
	Mrotz (p->T, p->a[Z]);

	Mangles (p->T, p->a, da[Y]);

	Vcopy (OLDV, p->V);
	EX->v[Y] = p->speed;
	Vscale (p->V, p->T[Y], p->speed);	/* faster than VMmul() */
	Vsub (A, p->V, OLDV);
	t = ihypot3d (A);
	if (t >= (VMAX/1000)*interval)
		EX->misc[5] = VMAX;
	else {
		EX->misc[5] = muldiv (t, 1000, interval);
		EX->misc[5] += fmul (GACC, p->T[Z][Z]);	/* pilot's gravity */
	}

	if ((EX->flags & PF_ONGROUND) && p->R[Z])
		EE(p)->flags &= ~PF_ONGROUND;

	EX->misc[10] = muldiv (p->speed, 1000, 366*VONE); /* good enough */

	if (p == CC) {
		st.indicators[0] = (p->R[Z] < 0) ? st.red : 0;
		st.indicators[1] = (p->R[Z]+p->V[Z] < 0) ? st.brown : 0;
		st.indicators[2] = (p->a[Y] > D90 || p->a[Y] < -D90)
							? st.green : 0;
	}
}
