/* -------------------------------- olow.c ---------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Object description: ground at close range.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "fly.h"

/* This is a small, simple x-y reference grid that follows the plane and
 * only shows when it is very low.
*/

static SHAPE shape_low = {
	0,
	0,
	0,
	1L,		/* weight */
	0		/* drag */
};

#define	GUNIT	100
#define HORIZON	(1000L*VONE)

static int FAR
init_low (BODY *b)
{
	int	i, last, g, h;
	VERTEX	*p, *vx_low;

	i = (int)(HORIZON/VONE/GUNIT);
	last = 2*i+1;

	if (!(vx_low = (VERTEX *)xcalloc (sizeof (VERTEX), 4*last+1)))
		return (1);

	shape_low.v = vx_low;

	h = GUNIT*i;
	for (g = -h, p = vx_low, i = 0; i < last; ++i, g += GUNIT) {
		p->V[X] = g;	p->V[Y] = -h;	p->V[Z] = 0;
		p->flags = V_MOVE;	++p;

		p->V[X] = g;	p->V[Y] = h;	p->V[Z] = 0;
		p->flags = V_DRAW;	++p;

		p->V[X] = -h;	p->V[Y] = g;	p->V[Z] = 0;
		p->flags = V_MOVE;	++p;

		p->V[X] = h;	p->V[Y] = g;	p->V[Z] = 0;
		p->flags = V_DRAW;	++p;
	}
	p->flags = 0;
	return (0);
}

static void FAR
term_low (BODY *b)
{
	shape_low.v = xfree (shape_low.v);
}

static int FAR
create_low (OBJECT *p)
{
	p->color = st.lred;
	p->time = FOREVER;
	Mident (p->T);

	return (0);
}

static void FAR
delete_low (OBJECT *p)
{
	return;
}

static void FAR
dynamics_low (OBJECT *p, int interval)
{
	p->R[X] = (((CV->R[X]/VONE+GUNIT/2)/GUNIT)*GUNIT)*VONE;
	p->R[Y] = (((CV->R[Y]/VONE+GUNIT/2)/GUNIT)*GUNIT)*VONE;
	return;
}

BODY BoLow = {
	0,
	0,
	"LOWLAND",
	&shape_low,
	init_low,
	term_low,
	create_low,
	delete_low,
	dynamics_low,
	body_hit
};
