/* --------------------------------- simple.prm ----------------------------- */

/*
 * This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
 *
 */

/* plane parameters: simple
*/

#include "parms.h"

600,		/* area */
40,		/* span */
7500,		/* weight */
15000/10,	/* thrust (mil) */
50,		/* sfc (mil) */
30000/10,	/* thrust (ab) */
150,		/* sfc (ab) */
100,		/* liftoff */
10,		/* max lift */
-7,		/* min lift */
34*VD90/90,	/* pitch */
180*VD90/90,	/* roll */
40,		/* flaps */
40,		/* spoilers */
10000,		/* fuel */
93,		/* efficiency */
10,		/* height */
0,		/* onground pitch */
50000,		/* ceiling */
515,		/* stores: M61   */
16,		/* stores: MK82  */
0,		/* stores: spare */
0,		/* stores: spare */
0,		/* stores: spare */

FCON(0.70),	/* friction with brakes applied */
FCON(0.02),	/* friction when freewheeling */
DEG2ANG(0),	/* Wing rigging angle vs. plane */
DEG2ANG(0),	/* Tail rigging angle vs. wing */
FCON(0.1),	/* tail volume */
FCON(5.0/30.0),	/* flaps effectiveness: alphaDEG/flapsDEG */
DEG2ANG(0),	/* alpha where Cl=0 */
FCON(1.5),	/* max Cl for wing foil */
FCON(0.05),	/* parasitic drag: profile */
FCON(0.50),	/* parasitic drag: speed brakes */
FCON(0.10),	/* parasitic drag: gear */
FCON(0.002),	/* parasitic drag: each MK82 */

FCON(40.0/57.0), /* max elevators */
FCON(30.0/57.0), /* max ailerons */

FCON(-0.01),	/* rudder sideforce */
FCON(-1.00),	/* vx damping */

FCON( 0.02),	/* elevators effectiveness */
FCON(-0.30),	/* pitch damping */
FCON( 0.00),	/* stabilizer induced pitch */
FCON( 0.00),	/* lift induced pitch */
FCON( 0.00),	/* drag induced pitch */
FCON( 0.00),	/* thrust induced pitch */

FCON(-0.15),	/* ailerons effectiveness */
FCON(-0.40),	/* roll damping */
FCON( 0.00),	/* dihedral effect */

FCON(-0.03),	/* rudder effectiveness */
FCON(-0.50),	/* yaw damping */
FCON( 0.10),	/* weathercock stability */
FCON( 0.00),	/* ailerons induced yaw */
FCON( 0.00),	/* roll induced yaw */

HUD_CLASSIC,	/* HUD type */

/*
 * these 10 options are for future use.
*/
	MODEL_XPLANE,	/* flight dynamics: 0=basic 1=classic 2=xperimental */
	0,		/* response */
	0,		/* 0=log, 1=linear control of pointer */
	0,		/* turn speed (classic), lift (basic) */
	0,		/* 1=allow stall */
	0,		/* reserved */
	0,		/* reserved */
	0,		/* reserved */
	0,		/* reserved */
	0,		/* reserved */
/*
 * these are the three PID parameter sets
 *
 *		P,	Iband, Ki,	Dband, Kd,	factor,		limit
 */
/* throttle */	400,	20*VONE, 10,	50*VONE, 400,	1000*VONE,	20,
/* pitch    */	400,	D90/30, 1,	D90/1, 400,	100*D90/50,	50,
/* roll     */	500,	0, 1000,	D90/1, 1000,	-100*D90/50,	100
