/* --------------------------------- console.c ------------------------------ */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Console keyboard handler: X11 (most code actualy in grX.c).
*/

#include <stdio.h>

#include "fly.h"

extern int xkread (void);

static int FAR
kread (void)
{
	return (xkread ());
}

static int FAR
kwait (void)
{
	int	esc, c;

	while (-1 == (c = kread ()))
		sys_poll ();
	for (esc = 0; -1 != c; c = kread ())
		if (K_ESC == c)
			esc = 1;
	return (esc);
}

static int FAR
kgetch (void)
{
	int	c;

	while ((c = kread ()) == -1)
		sys_poll ();
	return (c);
}

static int FAR
kinit (void)
{
	return (0);
}

static void FAR
kterm (void)
{
}

struct KbdDriver KbdConsole = {
	"CONSOLE",
	0,
	kinit,
	kterm,
	kread,
	kgetch,
	kwait
};

