UNIT  XPalette;      (* a faster SetRGBPalette-routine *)

INTERFACE
PROCEDURE      XSetPalette(start, n : WORD;  VAR RGB_Table );
(* set 'n' entries in the colour palette starting at 'start',
   RGB_Table has to be a data-struct containing n 3-byte-components
             the bytes describe the R,G,B-values ([0..63]) to be set *)

IMPLEMENTATION
USES DOS;

PROCEDURE      XSetPalette(start, n : WORD;  VAR RGB_Table );
VAR   r : Registers;
BEGIN
  r.ax := $1012;
  r.bx := start;
  r.cx := n;
  r.es := SEG(RGB_Table);
  r.dx := OFS(RGB_Table);
  INTR($10 , r);
END;

END. (* XPalette *)
