/*********************************************/
/* you just keep on pushing my luck over the */
/*           BOULDER        DASH             */
/*                                           */
/*     Jeroen Houttuin, ETH Zurich, 1990     */
/*                                           */
/*                                           */
/*	  PC-VGA version from :				*/
/*                                           */
/*		Herve SOULARD, Paris, 1990		*/
/*                                           */
/*********************************************/


#include "sound.h"


#ifndef _XBD_H_

#define _XBD_H_

#define w				35
#define h				26
#define LEVELPREFIX		"xbdlv"

#define SCORESIZE		18
#define LIB			".\\lib"

/* direction masks */
#define N				 0
#define E				 1
#define S				 2
#define W				 3
#define NODIR			 4

#define SPACEEXPLO		 0
#define BOULDEXPLO		10
#define DIAEXPLO		20
#define PROPAGATED		10

#define PLAYER			'p'
#define SPACE			' '
#define LMONSTER		'l'	/* Right turning monster */
#define RMONSTER		'r'
#define GRASS			'g'
#define WALL			'w'
#define MAGICWALL		'W'	/* Expanding wall */
#define DIAMOND		'd'
#define STEEL			'S'
#define BOULDER		'b'
#define EXPLOSION		'x'
#define EXIT			'E'
#define EATER			'e'
#define NUCBAL			'n'	/* Nuclear ballon */
#define BLOB			'B'	/* lava */
#define TINKLE			't'	/* Tinkle wall */

#define NB_EDIT_PGM		16

#define K_question		'?'
#define K_slash		'/'

#ifndef byte
#define byte	unsigned char
#endif

#define ALT_SHIFT		 8
#define CTL_SHIFT		 4
#define LEFT_SHIFT		 2
#define RIGHT_SHIFT		 1

#define K_HOME			71
#define K_END			79
#define K_UP			72
#define K_DOWN			80
#define K_PGUP			73
#define K_PGDOWN		81
#define K_LEFT			75
#define K_RIGHT		77
#define K_INS			82
#define K_DEL			83
#define K_BACKSPACE		 8
#define K_RETURN		13
#define K_ESC			27
#define K_SPACE		32

#define K_CTL_UP		141
#define K_CTL_DOWN		145
#define K_CTL_LEFT		115
#define K_CTL_RIGHT		116


#define K_F1			59
#define K_F2			60
#define K_F3			61
#define K_F4			62
#define K_F5			63
#define K_F6			64
#define K_F7			65
#define K_F8			66
#define K_F9			67
#define K_F10			68

#define K_C			'C'
#define K_U			'U'
#define K_c			'c'
#define K_u			'u'
#define K_backslash		'b'
#define K_D			'D'
#define K_d			'd'
#define K_R			'R'
#define K_r			'r'



static int  far *kbdStatus   = (int  far *)0x00000417;  /* Etat du clavier */
static byte far *kbdBuffer   = (byte far *)0x00000400;  /* Tampon clavier  */
static int  far *kbdPtrRead  = (int  far *)0x0000041A;  /* Ptr lecture     */
static int  far *kbdPtrWrite = (int  far *)0x0000041C;  /* Ptr criture    */


#define Bool			enum Boolean
enum Boolean {
	FALSE, TRUE
};



char		*gc, *Bgc, *Bgc1, *Bgc2, *ngc, *egc, *egc1, *egc2, *Egc1, *Wgc,
		*Wgc2, *Egc2, *Egc, *lgc, *lgc1, *lgc2, *rgc, *rgc1, *rgc2, *xgc,
		*Sgc, *bgc, *dgc, *dgc1, *dgc2, *wgc, *pgc, *pgc1, *pgc2, *sgc,
		*ggc, *tgc, *tgc1, *tgc2, *tgc3;

char		filename[300];	/* Current file name of this level */
char		levname[64];	/* Levelname */
int		i, j, ii, jj, jjj;
int		blobbreak;
int		critical;
int		curtime;		/* Current clock tick number */
int		blobcells;
int		tinkdur;		/* Tinkle duration */
Bool		tinkact;		/* Tinkle active   */
Bool		levincreased;
int		x, y, xin, yin, players, lives, levelnum, levelstart, speed,
		diareq, diapoints, extradiapoints;
Bool		steal;		/* steal instead of go */
Bool		stoplevel, blobcollapse;

enum directs {
	STAND, UP, DOWN, LEFT, RIGHT, KILL
};

enum directs    curorder;	/* Current order which player has */
						/* typed at the keyboard. */

struct cell {
  char	content;
  Bool	changed;			/* has cell changed since last drawing */
  Bool	caught;			/* for BLOB */
  Bool	checked;			/* for BLOB algorithm */
  char	dir;
  short	speed;
  short	stage;			/* painting stage for blinking etc. */
} field[h][w];

Bool		gamestop;
Bool		scoreobs;			/* is score line obsolete ? */
int		levelnum;			/* Current level number */
int		lives;			/* Current number of lives */
int		score;			/* Total score */
int		speed;			/* Speed of game.  1 is slowest, 15 is
						 * default */

struct sound	sndExplode;
struct sound	sndWhizz;
struct sound	sndOver;
struct sound	sndYahoo;

#endif
